/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.dataflow.metrics.collector.model.Instance;
import org.springframework.cloud.dataflow.metrics.collector.model.Metric;

public class Application {
    private String name;
    private List<Instance> instances = new LinkedList<Instance>();
    private Collection<Metric<Double>> aggregateMetrics = new LinkedList<Metric<Double>>();

    @JsonCreator
    public Application(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    public Collection<Metric<Double>> getAggregateMetrics() {
        return this.getInstances().stream().map(instance -> instance.getMetrics()).flatMap(metrics -> metrics.stream()).filter(metric -> metric.getName().matches("integration\\.channel\\.(\\w*)\\.send\\.mean")).collect(Collectors.groupingBy(Metric::getName, Collectors.summingDouble(Metric::getValue))).entrySet().stream().map(entry -> new Metric<Number>((String)entry.getKey(), (Number)entry.getValue(), new Date())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

