/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.metrics.collector.MetricCollectorProperties;
import org.springframework.cloud.dataflow.metrics.collector.MetricsAggregator;
import org.springframework.cloud.dataflow.metrics.collector.endpoint.MetricsCollectorEndpoint;
import org.springframework.cloud.dataflow.metrics.collector.endpoint.RootEndpoint;
import org.springframework.cloud.dataflow.metrics.collector.model.ApplicationMetrics;
import org.springframework.cloud.dataflow.metrics.collector.model.Metric;
import org.springframework.cloud.dataflow.metrics.collector.services.ApplicationMetricsService;
import org.springframework.cloud.dataflow.metrics.collector.support.CaffeineHealthIndicator;
import org.springframework.cloud.dataflow.metrics.collector.support.MetricJsonSerializer;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.EntityLinks;

@Configuration
@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={MetricCollectorProperties.class})
public class MetricsCollectorConfiguration {
    @Autowired
    private MetricCollectorProperties properties;

    @Bean
    public MetricJsonSerializer jsonSerializer() {
        return new MetricJsonSerializer();
    }

    @Bean
    public Cache<String, LinkedList<ApplicationMetrics<Metric<Double>>>> metricsStorage() {
        return Caffeine.newBuilder().expireAfterWrite((long)this.properties.getEvictionTimeout().intValue(), TimeUnit.SECONDS).recordStats().build();
    }

    @Bean
    public ApplicationMetricsService applicationMetricsService(Cache<String, LinkedList<ApplicationMetrics<Metric<Double>>>> metricsStorage) {
        return new ApplicationMetricsService(metricsStorage);
    }

    @Bean
    public MetricsAggregator metricsAggregator(ApplicationMetricsService applicationMetricsService) {
        return new MetricsAggregator(applicationMetricsService);
    }

    @Bean
    public MetricsCollectorEndpoint metricsCollectorEndpoint(ApplicationMetricsService applicationMetricsService) {
        return new MetricsCollectorEndpoint(applicationMetricsService);
    }

    @Bean
    public RootEndpoint rootEndpoint(EntityLinks entityLinks) {
        return new RootEndpoint(entityLinks);
    }

    @Bean
    public CaffeineHealthIndicator caffeineHealthIndicator(Cache<String, LinkedList<ApplicationMetrics<Metric<Double>>>> metricsStorage) {
        return new CaffeineHealthIndicator(metricsStorage);
    }
}

