/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.metrics.collector.model.ApplicationMetrics;
import org.springframework.cloud.dataflow.metrics.collector.model.Metric;
import org.springframework.cloud.dataflow.metrics.collector.model.MicrometerMetric;
import org.springframework.cloud.dataflow.metrics.collector.services.ApplicationMetricsService;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MetricsAggregator {
    private Logger logger = LoggerFactory.getLogger(MetricsAggregator.class);
    private ObjectMapper mapper;
    private ApplicationMetricsService service;

    public MetricsAggregator(ApplicationMetricsService service) {
        this.service = service;
        this.mapper = new ObjectMapper();
    }

    @StreamListener(value="input")
    public void receive(String metrics) {
        try {
            ApplicationMetrics<Metric<Double>> applicationMetrics;
            if (StringUtils.hasText((String)metrics) && metrics.contains("spring.integration.send")) {
                ApplicationMetrics applicationMetrics2 = (ApplicationMetrics)this.mapper.readValue(metrics, (TypeReference)new Metric2TypeReference());
                applicationMetrics = this.convertMetric2ToMetric(applicationMetrics2);
                applicationMetrics.getProperties().put("spring.cloud.dataflow.stream.metrics.version", "2.0");
            } else {
                applicationMetrics = (ApplicationMetrics<Metric<Double>>)this.mapper.readValue(metrics, (TypeReference)new Metric1TypeReference());
                applicationMetrics.getProperties().put("spring.cloud.dataflow.stream.metrics.version", "1.0");
            }
            this.processApplicationMetrics(applicationMetrics);
        }
        catch (IOException e) {
            this.logger.warn("Invalid metrics Json", (Throwable)e);
        }
    }

    private ApplicationMetrics<Metric<Double>> convertMetric2ToMetric(ApplicationMetrics<MicrometerMetric<Number>> applicationMetrics2) {
        List metrics = applicationMetrics2.getMetrics().stream().filter(metric -> metric.getId().getName().matches("spring\\.integration\\.send")).filter(metric -> metric.getId().getTag("type").equals("channel")).filter(metric -> metric.getId().getTag("result").equals("success")).map(m2 -> new Metric<Double>(this.generateOldMetricName((MicrometerMetric<Number>)m2), m2.getCount().doubleValue() / (double)(applicationMetrics2.getInterval() / 1000L), m2.getTimestamp())).collect(Collectors.toList());
        ApplicationMetrics<Metric<Double>> applicationMetrics = new ApplicationMetrics<Metric<Double>>(applicationMetrics2.getName(), metrics);
        applicationMetrics.setCreatedTime(applicationMetrics2.getCreatedTime());
        applicationMetrics.setProperties(applicationMetrics2.getProperties());
        return applicationMetrics;
    }

    private String generateOldMetricName(MicrometerMetric<Number> metric2) {
        String oldMetricName = metric2.getId().getName();
        if (metric2.getId().getName().startsWith("spring.integration.")) {
            String channelName = metric2.getId().getTag("name");
            String metricResult = metric2.getId().getTag("result");
            String successSuffix = "success".equals(metricResult) ? "" : "." + metricResult;
            oldMetricName = "integration.channel." + channelName + ".send.mean" + successSuffix;
        }
        return oldMetricName;
    }

    private void processApplicationMetrics(ApplicationMetrics<Metric<Double>> metrics) {
        if (metrics.getProperties().get("spring.cloud.application.guid") != null && metrics.getProperties().get("spring.cloud.dataflow.stream.app.label") != null && metrics.getProperties().get("spring.cloud.dataflow.stream.name") != null) {
            this.service.add(metrics);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Metric : {} is missing key properties and will not be consumed by the collector", (Object)metrics.getName());
        }
    }

    private static final class Metric2TypeReference
    extends TypeReference<ApplicationMetrics<MicrometerMetric<Number>>> {
        private Metric2TypeReference() {
        }
    }

    private static final class Metric1TypeReference
    extends TypeReference<ApplicationMetrics<Metric<Number>>> {
        private Metric1TypeReference() {
        }
    }
}

