/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.services;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.cloud.dataflow.metrics.collector.model.Application;
import org.springframework.cloud.dataflow.metrics.collector.model.ApplicationMetrics;
import org.springframework.cloud.dataflow.metrics.collector.model.Instance;
import org.springframework.cloud.dataflow.metrics.collector.model.StreamMetrics;
import org.springframework.cloud.dataflow.metrics.collector.utils.YANUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationMetricsService {
    private final Pattern pattern = Pattern.compile("integration\\.channel\\.(\\w*)\\.sendCount");
    private Lock rwLock = new ReentrantLock();
    private Cache<String, LinkedList<ApplicationMetrics>> storage;
    private Logger logger = LoggerFactory.getLogger(ApplicationMetricsService.class);

    public ApplicationMetricsService(Cache<String, LinkedList<ApplicationMetrics>> storage) {
        this.storage = storage;
    }

    public void add(ApplicationMetrics applicationMetrics) {
        try {
            this.rwLock.lock();
            LinkedList<ApplicationMetrics> values = (LinkedList<ApplicationMetrics>)this.storage.getIfPresent((Object)applicationMetrics.getName());
            if (values == null) {
                values = new LinkedList<ApplicationMetrics>();
                values.addFirst(applicationMetrics);
            } else {
                values.addFirst(applicationMetrics);
                if (values.size() > 2) {
                    values.removeLast();
                }
            }
            this.storage.put((Object)applicationMetrics.getName(), values);
        }
        finally {
            this.rwLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StreamMetrics> toStreamMetrics(String filter) {
        LinkedList<StreamMetrics> entries = new LinkedList<StreamMetrics>();
        Set streamNames = null;
        try {
            this.rwLock.lock();
            streamNames = StringUtils.isEmpty((Object)filter) ? this.storage.asMap().values().stream().map(applicationMetrics -> String.valueOf(((ApplicationMetrics)applicationMetrics.getFirst()).getProperties().get("spring.cloud.dataflow.stream.name"))).collect(Collectors.toSet()) : StringUtils.commaDelimitedListToSet((String)filter);
            for (String streamName : streamNames) {
                StreamMetrics streamMetrics = null;
                List filteredList = this.storage.asMap().values().stream().filter(applicationMetrics -> ((ApplicationMetrics)applicationMetrics.getFirst()).getProperties().get("spring.cloud.dataflow.stream.name").equals(streamName)).collect(Collectors.toList());
                for (List applicationMetricsList : filteredList) {
                    streamMetrics = this.convert(applicationMetricsList, streamMetrics);
                }
                if (streamMetrics == null) continue;
                entries.add(streamMetrics);
            }
        }
        finally {
            this.rwLock.unlock();
        }
        return entries;
    }

    private StreamMetrics convert(List<ApplicationMetrics> applicationMetricsList, StreamMetrics root) {
        ApplicationMetrics applicationMetrics = applicationMetricsList.get(0);
        Assert.notNull((Object)applicationMetrics.getProperties().get("spring.cloud.dataflow.stream.name"), (String)"Missing STREAM_NAME from metrics properties");
        Assert.notNull((Object)applicationMetrics.getProperties().get("spring.cloud.dataflow.stream.app.label"), (String)"Missing APPLICATION_NAME from metrics properties");
        Assert.notNull((Object)applicationMetrics.getProperties().get("spring.cloud.application.guid"), (String)"Missing APPLICATION_GUID from metrics properties");
        StreamMetrics streamMetrics = root == null ? new StreamMetrics((String)applicationMetrics.getProperties().get("spring.cloud.dataflow.stream.name")) : root;
        Application application = new Application((String)applicationMetrics.getProperties().get("spring.cloud.dataflow.stream.app.label"));
        Instance instance = new Instance(applicationMetrics.getProperties().get("spring.cloud.application.guid").toString());
        if (applicationMetrics.getProperties().get("spring.application.index") != null) {
            Integer instanceIndex = YANUtils.toInteger(applicationMetrics.getProperties().get("spring.application.index"));
            instance.setIndex(instanceIndex);
        }
        instance.setMetrics(applicationMetrics.getMetrics().stream().filter(metric -> !metric.getName().matches("integration\\.channel\\.(\\w*)\\.send\\.mean")).collect(Collectors.toList()));
        instance.setProperties(applicationMetrics.getProperties());
        instance.setKey(applicationMetrics.getName());
        instance.getMetrics().addAll(this.computeRate(applicationMetricsList));
        int applicationIndex = streamMetrics.getApplications().indexOf(application);
        if (applicationIndex < 0) {
            application.getInstances().add(instance);
            streamMetrics.getApplications().add(application);
        } else {
            int idx = streamMetrics.getApplications().get(applicationIndex).getInstances().indexOf(instance);
            if (idx < 0) {
                streamMetrics.getApplications().get(applicationIndex).getInstances().add(instance);
            }
        }
        return streamMetrics;
    }

    private List<Metric<Double>> computeRate(List<ApplicationMetrics> applicationMetricsList) {
        ArrayList<Metric<Double>> result = new ArrayList<Metric<Double>>();
        ApplicationMetrics applicationMetrics = applicationMetricsList.get(0);
        for (Metric<Double> metric : applicationMetrics.getMetrics()) {
            Matcher matcher = this.pattern.matcher(metric.getName());
            if (!matcher.matches()) continue;
            Metric<Double> previous = applicationMetricsList.size() < 2 ? null : this.findMetric(applicationMetricsList.get(1).getMetrics(), metric.getName());
            result.add((Metric<Double>)new Metric("integration.channel." + matcher.group(1) + ".send.mean", (Number)this.delta(metric, previous)));
        }
        return result;
    }

    private Double delta(Metric<Double> current, Metric<Double> previous) {
        if (previous == null) {
            return 0.0;
        }
        return ((Double)current.getValue() - (Double)previous.getValue()) / (double)(current.getTimestamp().getTime() - previous.getTimestamp().getTime()) * 1000.0;
    }

    private Metric<Double> findMetric(Collection<Metric<Double>> metrics, String name) {
        Metric result = null;
        Optional<Metric> optinal = metrics.stream().filter(metric -> metric.getName().equals(name)).findFirst();
        result = optinal.isPresent() ? optinal.get() : new Metric(name, (Number)0.0);
        return result;
    }
}

