/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.metrics.collector.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.springframework.boot.actuate.metrics.Metric;

public class ApplicationMetrics {
    public static final String STREAM_NAME = "spring.cloud.dataflow.stream.name";
    public static final String APPLICATION_NAME = "spring.cloud.dataflow.stream.app.label";
    public static final String SERVER_NAME = "spring.cloud.dataflow.server.name";
    public static final String APPLICATION_TYPE = "spring.cloud.dataflow.stream.app.type";
    public static final String APPLICATION_GUID = "spring.cloud.application.guid";
    public static final String INSTANCE_INDEX = "spring.application.index";
    public static final String APPLICATION_METRICS_JSON = "application/vnd.spring.cloud.stream.metrics.v1+json";
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    private final Date createdTime;
    private String name;
    private Collection<Metric<Double>> metrics;
    private Map<String, Object> properties;

    @JsonCreator
    public ApplicationMetrics(@JsonProperty(value="name") String name, @JsonProperty(value="metrics") Collection<Metric<Double>> metrics) {
        this.name = name;
        this.metrics = metrics;
        this.createdTime = new Date();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Metric<Double>> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<Metric<Double>> metrics) {
        this.metrics = metrics;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationMetrics that = (ApplicationMetrics)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

