/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.xml;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.config.xml.AbstractPoolingCloudServiceFactoryParser;
import org.springframework.cloud.service.keyval.RedisConnectionFactoryConfig;
import org.springframework.cloud.service.keyval.RedisConnectionFactoryFactory;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CloudRedisConnectionFactoryParser
extends AbstractPoolingCloudServiceFactoryParser {
    private static final String ELEMENT_POOL = "pool";
    private static final String CONNECTION_PROPERTIES = "connection-properties";

    public CloudRedisConnectionFactoryParser() {
        super(RedisConnectionFactoryFactory.class);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        BeanDefinitionBuilder redisConfigBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)RedisConnectionFactoryConfig.class.getName());
        BeanDefinition cloudPoolConfiguration = null;
        Element poolElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_POOL);
        if (poolElement != null) {
            cloudPoolConfiguration = this.parsePoolElement(poolElement, parserContext);
        }
        redisConfigBeanBuilder.addConstructorArgValue(cloudPoolConfiguration);
        Element propertiesElement = DomUtils.getChildElementByTagName((Element)element, (String)CONNECTION_PROPERTIES);
        if (propertiesElement != null) {
            Map properties = parserContext.getDelegate().parseMapElement(propertiesElement, (BeanDefinition)builder.getRawBeanDefinition());
            redisConfigBeanBuilder.addConstructorArgValue((Object)properties);
        }
        builder.addConstructorArgValue((Object)redisConfigBeanBuilder.getBeanDefinition());
    }
}

