/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service;

import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.CloudServiceConnectorFactory;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.util.StringUtils;

public abstract class AbstractCloudServiceConnectorFactory<S>
extends AbstractFactoryBean<S>
implements CloudServiceConnectorFactory<S> {
    private static final String CLOUD_FACTORY_BEAN_NAME = "__cloud_factory__";
    private Cloud cloud;
    protected String serviceId;
    private Class<? extends S> serviceConnectorType;
    private ServiceConnectorConfig serviceConnectorConfiguration;
    private S serviceInstance;

    public AbstractCloudServiceConnectorFactory(String serviceId, Class<S> serviceConnectorType, ServiceConnectorConfig serviceConnectorConfiguration) {
        this.serviceId = serviceId;
        this.serviceConnectorType = serviceConnectorType;
        this.serviceConnectorConfiguration = serviceConnectorConfiguration;
    }

    public AbstractCloudServiceConnectorFactory(Class<S> serviceConnectorType, ServiceConnectorConfig serviceConnectorConfiguration) {
        this(null, serviceConnectorType, serviceConnectorConfiguration);
    }

    public void setCloud(Cloud cloud) {
        this.cloud = cloud;
    }

    public void afterPropertiesSet() throws Exception {
        ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)this.getBeanFactory();
        if (this.cloud == null) {
            if (beanFactory.getBeansOfType(CloudFactory.class).isEmpty()) {
                beanFactory.registerSingleton(CLOUD_FACTORY_BEAN_NAME, (Object)new CloudFactory());
            }
            CloudFactory cloudFactory = (CloudFactory)beanFactory.getBeansOfType(CloudFactory.class).values().iterator().next();
            this.cloud = cloudFactory.getCloud();
        }
        if (!StringUtils.hasText((String)this.serviceId)) {
            List infos = this.cloud.getServiceInfos(this.serviceConnectorType);
            if (infos.size() != 1) {
                throw new CloudException("Expected 1 service matching " + this.serviceConnectorType.getName() + " type, but found " + infos.size());
            }
            this.serviceId = ((ServiceInfo)infos.get(0)).getId();
        }
        super.afterPropertiesSet();
    }

    protected S createInstance() throws Exception {
        return this.createService();
    }

    public S createService() {
        if (this.serviceInstance == null && this.cloud != null) {
            this.serviceInstance = this.cloud.getServiceConnector(this.serviceId, this.serviceConnectorType, this.serviceConnectorConfiguration);
            if (this.serviceInstance != null && FactoryBean.class.isAssignableFrom(this.serviceInstance.getClass())) {
                try {
                    this.serviceInstance = ((FactoryBean)this.serviceInstance).getObject();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return this.serviceInstance;
    }

    public Class<?> getObjectType() {
        if (this.serviceConnectorType == null) {
            try {
                this.serviceConnectorType = this.createService().getClass();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.serviceConnectorType;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceConnectorType(Class<? extends S> serviceConnectorType) {
        if (serviceConnectorType != null) {
            this.serviceConnectorType = serviceConnectorType;
        }
    }
}

