/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.document;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorCreationException;
import org.springframework.cloud.service.common.MongoServiceInfo;
import org.springframework.cloud.service.document.MongoDbFactoryConfig;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MongoDbFactoryCreator
extends AbstractServiceConnectorCreator<MongoDbFactory, MongoServiceInfo> {
    public MongoDbFactory create(MongoServiceInfo serviceInfo, ServiceConnectorConfig config) {
        try {
            MongoClientOptions mongoOptionsToUse = this.getMongoOptions((MongoDbFactoryConfig)config);
            MongoClientURI mongoClientURI = new MongoClientURI(serviceInfo.getUri());
            List<ServerAddress> serverAddressList = this.getServerAddresses(mongoClientURI);
            MongoClient mongo = new MongoClient(serverAddressList, mongoOptionsToUse);
            UserCredentials credentials = new UserCredentials(mongoClientURI.getUsername(), new String(mongoClientURI.getPassword()));
            SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory((Mongo)mongo, mongoClientURI.getDatabase(), credentials);
            return this.configure(mongoDbFactory, (MongoDbFactoryConfig)config);
        }
        catch (UnknownHostException e) {
            throw new ServiceConnectorCreationException((Throwable)e);
        }
        catch (MongoException e) {
            throw new ServiceConnectorCreationException((Throwable)e);
        }
    }

    private List<ServerAddress> getServerAddresses(MongoClientURI mongoClientURI) throws UnknownHostException {
        List servers = mongoClientURI.getHosts();
        ArrayList<ServerAddress> serverAddressList = new ArrayList<ServerAddress>();
        for (String server : servers) {
            serverAddressList.add(new ServerAddress(server));
        }
        return serverAddressList;
    }

    private MongoClientOptions getMongoOptions(MongoDbFactoryConfig config) {
        MongoClientOptions.Builder builder;
        Method builderMethod = ClassUtils.getMethodIfAvailable(MongoClientOptions.class, (String)"builder", (Class[])new Class[0]);
        if (builderMethod != null) {
            builder = (MongoClientOptions.Builder)ReflectionUtils.invokeMethod((Method)builderMethod, null);
        } else {
            Constructor builderConstructor = ClassUtils.getConstructorIfAvailable(MongoClientOptions.Builder.class, (Class[])new Class[0]);
            try {
                builder = (MongoClientOptions.Builder)builderConstructor.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        if (config != null) {
            if (config.getConnectionsPerHost() != null) {
                builder.connectionsPerHost(config.getConnectionsPerHost().intValue());
            }
            if (config.getMaxWaitTime() != null) {
                builder.maxWaitTime(config.getMaxWaitTime().intValue());
            }
            if (config.getWriteConcern() != null) {
                builder.writeConcern(new WriteConcern(config.getWriteConcern()));
            }
        }
        return builder.build();
    }

    public SimpleMongoDbFactory configure(SimpleMongoDbFactory mongoDbFactory, MongoDbFactoryConfig config) {
        WriteConcern writeConcern;
        if (config != null && config.getWriteConcern() != null && (writeConcern = WriteConcern.valueOf((String)config.getWriteConcern())) != null) {
            mongoDbFactory.setWriteConcern(writeConcern);
        }
        return mongoDbFactory;
    }
}

