/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.config;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.config.server.EnableConfigServer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"server.port=0", "spring.cloud.config.server.git.uri=https://github.com/spring-cloud-samples/config-repo"})
public abstract class ConfigServerIntegrationTests {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    WebClientService webClientService;
    @LocalServerPort
    int port;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    @Test
    public void should_instrument_config_server() {
        this.webClientService.call(this.port);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> {
            ((ListAssert)BDDAssertions.then(this.spans.reportedSpans()).as("1 for mvc, 1 for composite env repo and 1 for git env repo", new Object[0])).hasSize(3);
            ((AbstractCollectionAssert)BDDAssertions.then((Collection)this.spans.reportedSpans().stream().map(FinishedSpan::getTraceId).collect(Collectors.toSet())).as("There must be 1 trace id", new Object[0])).hasSize(1);
        });
    }

    public static class WebClientService {
        private static final Logger log = LoggerFactory.getLogger(WebClientService.class);

        void call(int port) {
            log.info("Sending request");
            String result = (String)new RestTemplate().getForObject("http://localhost:" + port + "/foo/default/main", String.class, new Object[0]);
            log.info("Got [\n" + result + "\n]");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableConfigServer
    public static class TestConfig {
        @Bean
        WebClientService webClientService() {
            return new WebClientService();
        }
    }
}

