/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskScheduler;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListenerAccessor;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ErrorHandler;

@ExtendWith(value={MockitoExtension.class})
public abstract class LazyTraceThreadPoolTaskSchedulerTests
implements TestTracingAwareSupplier {
    @Mock(lenient=true)
    BeanFactory beanFactory;
    @Mock
    ThreadPoolTaskScheduler delegate;
    LazyTraceThreadPoolTaskScheduler executor;

    @BeforeEach
    public void setup() {
        this.executor = new LazyTraceThreadPoolTaskScheduler(this.beanFactory(), this.delegate, null);
    }

    @AfterEach
    public void close() {
        this.executor.shutdown();
    }

    BeanFactory beanFactory() {
        BDDMockito.given((Object)this.beanFactory.getBean(Tracer.class)).willReturn((Object)this.tracerTest().tracing().tracer());
        BDDMockito.given((Object)this.beanFactory.getBean(SpanNamer.class)).willReturn((Object)new DefaultSpanNamer());
        SleuthContextListenerAccessor.set(this.beanFactory, true);
        return this.beanFactory;
    }

    @Test
    public void setPoolSize() {
        this.executor.setPoolSize(10);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setPoolSize(10);
    }

    @Test
    public void setRemoveOnCancelPolicy() {
        this.executor.setRemoveOnCancelPolicy(true);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setRemoveOnCancelPolicy(true);
    }

    @Test
    public void setErrorHandler() {
        ErrorHandler handler = throwable -> {};
        this.executor.setErrorHandler(handler);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setErrorHandler(handler);
    }

    @Test
    public void getScheduledExecutor() {
        this.executor.getScheduledExecutor();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).getScheduledExecutor();
    }

    @Test
    public void getPoolSize() {
        this.executor.getPoolSize();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).getPoolSize();
    }

    @Test
    public void isRemoveOnCancelPolicy() {
        this.executor.setRemoveOnCancelPolicy(true);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setRemoveOnCancelPolicy(true);
    }

    @Test
    public void getActiveCount() {
        this.executor.getActiveCount();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).getActiveCount();
    }

    @Test
    public void execute() {
        Runnable r = () -> {};
        this.executor.execute(r);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).execute((Runnable)BDDMockito.any(TraceRunnable.class));
    }

    @Test
    public void execute1() {
        Runnable r = () -> {};
        this.executor.execute(r, 10L);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).execute((Runnable)BDDMockito.any(TraceRunnable.class), BDDMockito.eq((long)10L));
    }

    @Test
    public void submit() {
        Runnable c = () -> {};
        this.executor.submit(c);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).submit((Runnable)BDDMockito.any(TraceRunnable.class));
    }

    @Test
    public void submit1() {
        Callable<Object> c = () -> null;
        this.executor.submit(c);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).submit((Callable)BDDMockito.any(TraceCallable.class));
    }

    @Test
    public void submitListenable() {
        Runnable c = () -> {};
        this.executor.submitListenable(c);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).submitListenable((Runnable)BDDMockito.any(TraceRunnable.class));
    }

    @Test
    public void submitListenable1() {
        Callable<Object> c = () -> null;
        this.executor.submitListenable(c);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).submitListenable((Callable)BDDMockito.any(TraceCallable.class));
    }

    @Test
    public void prefersShortLivedTasks() {
        this.executor.prefersShortLivedTasks();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).prefersShortLivedTasks();
    }

    @Test
    public void schedule() {
        Runnable c = () -> {};
        Trigger trigger = triggerContext -> null;
        this.executor.schedule(c, trigger);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).schedule((Runnable)BDDMockito.any(TraceRunnable.class), (Trigger)BDDMockito.eq((Object)trigger));
    }

    @Test
    public void schedule1() {
        Runnable c = () -> {};
        Date date = new Date();
        this.executor.schedule(c, date);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).schedule((Runnable)BDDMockito.any(TraceRunnable.class), (Date)BDDMockito.eq((Object)date));
    }

    @Test
    public void scheduleAtFixedRate() {
        Runnable c = () -> {};
        Date date = new Date();
        this.executor.scheduleAtFixedRate(c, date, 10L);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleAtFixedRate((Runnable)BDDMockito.any(TraceRunnable.class), (Date)BDDMockito.eq((Object)date), BDDMockito.eq((long)10L));
    }

    @Test
    public void scheduleAtFixedRate1() {
        Runnable c = () -> {};
        this.executor.scheduleAtFixedRate(c, 10L);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleAtFixedRate((Runnable)BDDMockito.any(TraceRunnable.class), BDDMockito.eq((long)10L));
    }

    @Test
    public void scheduleWithFixedDelay() {
        Runnable c = () -> {};
        Date date = new Date();
        this.executor.scheduleWithFixedDelay(c, date, 10L);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleWithFixedDelay((Runnable)BDDMockito.any(TraceRunnable.class), (Date)BDDMockito.eq((Object)date), BDDMockito.eq((long)10L));
    }

    @Test
    public void scheduleWithFixedDelay1() {
        Runnable c = () -> {};
        this.executor.scheduleWithFixedDelay(c, 10L);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleWithFixedDelay((Runnable)BDDMockito.any(TraceRunnable.class), BDDMockito.eq((long)10L));
    }

    @Test
    public void scheduleWithFixedDelay2() {
        Runnable c = () -> {};
        Instant instant = Instant.now();
        Duration duration = Duration.ZERO;
        this.executor.scheduleWithFixedDelay(c, instant, duration);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleWithFixedDelay((Runnable)BDDMockito.any(TraceRunnable.class), (Instant)BDDMockito.eq((Object)instant), (Duration)BDDMockito.eq((Object)duration));
    }

    @Test
    public void scheduleWithFixedDelay3() {
        Runnable c = () -> {};
        Duration duration = Duration.ZERO;
        this.executor.scheduleWithFixedDelay(c, duration);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleWithFixedDelay((Runnable)BDDMockito.any(TraceRunnable.class), (Duration)BDDMockito.eq((Object)duration));
    }

    @Test
    public void setThreadFactory() {
        ThreadFactory threadFactory = r -> null;
        this.executor.setThreadFactory(threadFactory);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setThreadFactory(threadFactory);
    }

    @Test
    public void setThreadNamePrefix() {
        this.executor.setThreadNamePrefix("foo");
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setThreadNamePrefix("foo");
    }

    @Test
    public void setRejectedExecutionHandler() {
        RejectedExecutionHandler handler = (r, executor1) -> {};
        this.executor.setRejectedExecutionHandler(handler);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setRejectedExecutionHandler(handler);
    }

    @Test
    public void setWaitForTasksToCompleteOnShutdown() {
        this.executor.setWaitForTasksToCompleteOnShutdown(true);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setWaitForTasksToCompleteOnShutdown(true);
    }

    @Test
    public void setAwaitTerminationSeconds() {
        this.executor.setAwaitTerminationSeconds(10);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setAwaitTerminationSeconds(10);
    }

    @Test
    public void setBeanName() {
        this.executor.setBeanName("foo");
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setBeanName("foo");
    }

    @Test
    public void afterPropertiesSet() {
        this.executor.afterPropertiesSet();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).afterPropertiesSet();
    }

    @Test
    public void initialize() {
        this.executor.initialize();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).initialize();
    }

    @Test
    public void destroy() {
        this.executor.destroy();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).destroy();
    }

    @Test
    public void shutdown() {
        this.executor.shutdown();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).shutdown();
    }

    @Test
    public void newThread() {
        Runnable runnable = () -> {};
        this.executor.newThread(runnable);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).newThread((Runnable)BDDMockito.isA(TraceRunnable.class));
    }

    @Test
    public void getThreadNamePrefix() {
        this.executor.getThreadNamePrefix();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).getThreadNamePrefix();
    }

    @Test
    public void setThreadPriority() {
        this.executor.setThreadPriority(10);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setThreadPriority(10);
    }

    @Test
    public void getThreadPriority() {
        this.executor.getThreadPriority();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).getThreadPriority();
    }

    @Test
    public void setDaemon() {
        this.executor.setDaemon(true);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setDaemon(true);
    }

    @Test
    public void isDaemon() {
        this.executor.isDaemon();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).isDaemon();
    }

    @Test
    public void setThreadGroupName() {
        this.executor.setThreadGroupName("foo");
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setThreadGroupName("foo");
    }

    @Test
    public void setThreadGroup() {
        ThreadGroup threadGroup = new ThreadGroup("foo");
        this.executor.setThreadGroup(threadGroup);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).setThreadGroup(threadGroup);
    }

    @Test
    public void getThreadGroup() {
        this.executor.getThreadGroup();
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).getThreadGroup();
    }

    @Test
    public void createThread() {
        Runnable r = () -> {};
        this.executor.createThread(r);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).createThread((Runnable)BDDMockito.isA(TraceRunnable.class));
    }

    @Test
    public void schedule2() {
        Runnable r = () -> {};
        Instant instant = Instant.now();
        this.executor.schedule(r, instant);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).schedule((Runnable)BDDMockito.any(TraceRunnable.class), (Instant)BDDMockito.eq((Object)instant));
    }

    @Test
    public void scheduleAtFixedRate2() {
        Runnable r = () -> {};
        Instant instant = Instant.now();
        Duration duration = Duration.ZERO;
        this.executor.scheduleAtFixedRate(r, instant, duration);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleAtFixedRate((Runnable)BDDMockito.any(TraceRunnable.class), (Instant)BDDMockito.eq((Object)instant), (Duration)BDDMockito.eq((Object)duration));
    }

    @Test
    public void scheduleAtFixedRate3() {
        Runnable r = () -> {};
        Duration duration = Duration.ZERO;
        this.executor.scheduleAtFixedRate(r, duration);
        ((ThreadPoolTaskScheduler)BDDMockito.then((Object)this.delegate).should()).scheduleAtFixedRate((Runnable)BDDMockito.any(TraceRunnable.class), (Duration)BDDMockito.eq((Object)duration));
    }
}

