/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.JaegerPropagator;
import io.opentelemetry.extension.trace.propagation.OtTracePropagator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.otel.propagation.PropagationType;
import org.springframework.util.ClassUtils;

public class CompositeTextMapPropagator
implements TextMapPropagator {
    private static final Log log = LogFactory.getLog(CompositeTextMapPropagator.class);
    private final Map<PropagationType, TextMapPropagator> mapping = new HashMap<PropagationType, TextMapPropagator>();
    private final List<PropagationType> types;

    public CompositeTextMapPropagator(BeanFactory beanFactory, List<PropagationType> types) {
        this.types = types;
        if (this.isOnClasspath(this.awsClass())) {
            this.mapping.put(PropagationType.AWS, (TextMapPropagator)beanFactory.getBeanProvider(AwsXrayPropagator.class).getIfAvailable(AwsXrayPropagator::getInstance));
        } else if (this.isOnClasspath(this.deprecatedAwsClass())) {
            this.mapping.put(PropagationType.AWS, (TextMapPropagator)beanFactory.getBeanProvider(io.opentelemetry.extension.aws.AwsXrayPropagator.class).getIfAvailable(io.opentelemetry.extension.aws.AwsXrayPropagator::getInstance));
        }
        if (this.isOnClasspath(this.b3Class())) {
            this.mapping.put(PropagationType.B3, (TextMapPropagator)beanFactory.getBeanProvider(B3Propagator.class).getIfAvailable(B3Propagator::injectingSingleHeader));
        }
        if (this.isOnClasspath(this.jaegerClass())) {
            this.mapping.put(PropagationType.JAEGER, (TextMapPropagator)beanFactory.getBeanProvider(JaegerPropagator.class).getIfAvailable(JaegerPropagator::getInstance));
        }
        if (this.isOnClasspath(this.otClass())) {
            this.mapping.put(PropagationType.OT_TRACER, (TextMapPropagator)beanFactory.getBeanProvider(OtTracePropagator.class).getIfAvailable(OtTracePropagator::getInstance));
        }
        this.mapping.put(PropagationType.W3C, TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}));
        this.mapping.put(PropagationType.CUSTOM, NoopTextMapPropagator.INSTANCE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered the following context propagation types " + this.mapping.keySet()));
        }
    }

    String otClass() {
        return "io.opentelemetry.extension.trace.propagation.OtTracePropagator";
    }

    String jaegerClass() {
        return "io.opentelemetry.extension.trace.propagation.JaegerPropagator";
    }

    String b3Class() {
        return "io.opentelemetry.extension.trace.propagation.B3Propagator";
    }

    String deprecatedAwsClass() {
        return "io.opentelemetry.extension.aws.AwsXrayPropagator";
    }

    String awsClass() {
        return "io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator";
    }

    private boolean isOnClasspath(String clazz) {
        return ClassUtils.isPresent((String)clazz, null);
    }

    public List<String> fields() {
        return this.types.stream().map(key -> this.mapping.getOrDefault(key, NoopTextMapPropagator.INSTANCE)).flatMap(p -> p.fields().stream()).collect(Collectors.toList());
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        this.types.stream().map(key -> this.mapping.getOrDefault(key, NoopTextMapPropagator.INSTANCE)).forEach(p -> p.inject(context, carrier, setter));
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
        for (PropagationType type : this.types) {
            TextMapPropagator propagator = this.mapping.get((Object)type);
            if (propagator == null || propagator == NoopTextMapPropagator.INSTANCE) continue;
            Context extractedContext = propagator.extract(context, carrier, getter);
            Span span = Span.fromContextOrNull((Context)extractedContext);
            Baggage baggage = Baggage.fromContextOrNull((Context)extractedContext);
            if (span == null && baggage == null) continue;
            return extractedContext;
        }
        return context;
    }

    private static final class NoopTextMapPropagator
    implements TextMapPropagator {
        private static final NoopTextMapPropagator INSTANCE = new NoopTextMapPropagator();

        private NoopTextMapPropagator() {
        }

        public List<String> fields() {
            return Collections.emptyList();
        }

        public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        }

        public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
            return context;
        }
    }
}

