/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.tracer.HttpClientTracer;
import io.opentelemetry.instrumentation.api.tracer.net.NetPeerAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.SamplerFunction;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpResponse;
import org.springframework.cloud.sleuth.http.HttpResponseParser;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class OtelHttpClientHandler
extends HttpClientTracer<HttpClientRequest, HttpClientRequest, HttpClientResponse>
implements HttpClientHandler {
    private static final Log log = LogFactory.getLog(OtelHttpClientHandler.class);
    private final HttpRequestParser httpClientRequestParser;
    private final HttpResponseParser httpClientResponseParser;
    private final SamplerFunction<HttpRequest> samplerFunction;

    public OtelHttpClientHandler(OpenTelemetry openTelemetry, @Nullable HttpRequestParser httpClientRequestParser, @Nullable HttpResponseParser httpClientResponseParser, SamplerFunction<HttpRequest> samplerFunction) {
        super(openTelemetry, new NetPeerAttributes());
        this.httpClientRequestParser = httpClientRequestParser;
        this.httpClientResponseParser = httpClientResponseParser;
        this.samplerFunction = samplerFunction;
    }

    public Context startSpan(Context parentContext, HttpClientRequest request, HttpClientRequest carrier, long startTimeNanos) {
        String path;
        Context context = super.startSpan(parentContext, (Object)request, (Object)carrier, startTimeNanos);
        io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.fromContext((Context)context);
        if (this.httpClientRequestParser != null) {
            Span fromOtel = OtelSpan.fromOtel(span);
            this.httpClientRequestParser.parse((HttpRequest)request, fromOtel.context(), (SpanCustomizer)fromOtel);
        }
        if ((path = request.path()) != null) {
            span.setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)path);
        }
        return context;
    }

    public Span handleSend(HttpClientRequest request) {
        if (Boolean.FALSE.equals(this.samplerFunction.trySample((Object)request))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The sampler function filtered this request, will return an invalid span");
            }
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        Context context = this.startSpan(Context.current(), request, request);
        return this.span(request, context);
    }

    public Span handleSend(HttpClientRequest request, TraceContext parent) {
        io.opentelemetry.api.trace.Span span;
        if (Boolean.FALSE.equals(this.samplerFunction.trySample((Object)request))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning an invalid span since url [" + request.path() + "] is on a list of urls to skip"));
            }
            return OtelSpan.fromOtel(io.opentelemetry.api.trace.Span.getInvalid());
        }
        io.opentelemetry.api.trace.Span span2 = span = parent != null ? ((OtelTraceContext)parent).span() : null;
        if (span == null) {
            return this.span(request, this.startSpan(Context.current(), request, request));
        }
        try (Scope scope = span.makeCurrent();){
            Context withParent = this.startSpan(Context.current(), request, request);
            Span span3 = this.span(request, withParent);
            return span3;
        }
    }

    private Span span(HttpClientRequest request, Context context) {
        try (Scope scope = context.makeCurrent();){
            io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.current();
            String remoteIp = request.remoteIp();
            if (StringUtils.hasText((String)remoteIp)) {
                span.setAttribute(SemanticAttributes.NET_PEER_IP, (Object)remoteIp);
            }
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, request.remotePort());
            Span span2 = OtelSpan.fromOtel(span);
            return span2;
        }
    }

    protected void onResponse(io.opentelemetry.api.trace.Span span, HttpClientResponse httpClientResponse) {
        super.onResponse(span, (Object)httpClientResponse);
        if (this.httpClientResponseParser != null) {
            Span fromOtel = OtelSpan.fromOtel(span);
            this.httpClientResponseParser.parse((HttpResponse)httpClientResponse, fromOtel.context(), (SpanCustomizer)fromOtel);
        }
    }

    public void handleReceive(HttpClientResponse response, Span span) {
        io.opentelemetry.api.trace.Span otelSpan = OtelSpan.toOtel(span);
        if (otelSpan.equals(io.opentelemetry.api.trace.Span.getInvalid())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not doing anything because the span is invalid");
            }
            return;
        }
        if (response.error() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There was an error, will finish span [" + otelSpan + "] exceptionally"));
            }
            this.endExceptionally(Context.current().with((ImplicitContextKeyed)otelSpan), response, response.error());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There was no error, will finish span [" + otelSpan + "] in a standard way"));
            }
            this.end(Context.current().with((ImplicitContextKeyed)otelSpan), response);
        }
    }

    protected String method(HttpClientRequest httpClientRequest) {
        return httpClientRequest.method();
    }

    protected URI url(HttpClientRequest httpClientRequest) throws URISyntaxException {
        return URI.create(httpClientRequest.url());
    }

    protected Integer status(HttpClientResponse httpClientResponse) {
        return httpClientResponse.statusCode();
    }

    protected String requestHeader(HttpClientRequest httpClientRequest, String s) {
        return httpClientRequest.header(s);
    }

    protected String responseHeader(HttpClientResponse httpClientResponse, String s) {
        return httpClientResponse.header(s);
    }

    protected TextMapSetter<HttpClientRequest> getSetter() {
        return HttpClientRequest::header;
    }

    protected String getInstrumentationName() {
        return "org.springframework.cloud.sleuth";
    }
}

