/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.security.SleuthSecuritySpan;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextChangedEvent;
import org.springframework.security.core.context.SecurityContextChangedListener;

public class TracingSecurityContextChangedListener
implements SecurityContextChangedListener {
    private static final Log log = LogFactory.getLog(TracingSecurityContextChangedListener.class);
    private final Tracer tracer;

    public TracingSecurityContextChangedListener(Tracer tracer) {
        this.tracer = tracer;
    }

    public void securityContextChanged(SecurityContextChangedEvent securityContextChangedEvent) {
        Authentication currentAuthentication;
        SecurityContext previousContext = securityContextChangedEvent.getOldContext();
        SecurityContext currentContext = securityContextChangedEvent.getNewContext();
        Authentication previousAuthentication = previousContext != null ? previousContext.getAuthentication() : null;
        Authentication authentication = currentAuthentication = currentContext != null ? currentContext.getAuthentication() : null;
        if (previousAuthentication != null) {
            if (currentAuthentication != null) {
                this.attachEvent(SleuthSecuritySpan.SleuthSecurityEvent.AUTHENTICATION_REPLACED, this.toString(previousAuthentication, currentAuthentication));
            } else {
                this.attachEvent(SleuthSecuritySpan.SleuthSecurityEvent.AUTHENTICATION_CLEARED, this.toString(previousAuthentication));
            }
        } else if (currentAuthentication != null) {
            this.attachEvent(SleuthSecuritySpan.SleuthSecurityEvent.AUTHENTICATION_SET, this.toString(currentAuthentication));
        }
    }

    private String toString(Authentication previousAuthentication, Authentication currentAuthentication) {
        return this.toString(previousAuthentication) + " -> " + this.toString(currentAuthentication);
    }

    private String toString(Authentication authentication) {
        return authentication != null ? authentication.getClass().getSimpleName() + authentication.getAuthorities() : "null";
    }

    private void attachEvent(SleuthSecuritySpan.SleuthSecurityEvent sleuthSecurityEvent, String ... params) {
        Span span = this.tracer.currentSpan();
        if (span != null) {
            String event = String.format(sleuthSecurityEvent.getValue(), params);
            if (log.isDebugEnabled()) {
                log.debug((Object)event);
            }
            SleuthSecuritySpan.SECURITY_CONTEXT_CHANGE.wrap(span).event(event);
        }
    }
}

