/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.task;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.instrument.task.SleuthTaskSpan;

public class TraceApplicationRunner
implements ApplicationRunner {
    private final BeanFactory beanFactory;
    private final ApplicationRunner delegate;
    private final String beanName;
    private Tracer tracer;

    public TraceApplicationRunner(BeanFactory beanFactory, ApplicationRunner delegate, String beanName) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = beanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ApplicationArguments args) throws Exception {
        AssertingSpan span = SleuthTaskSpan.TASK_RUNNER_SPAN.wrap(this.tracer().nextSpan()).name(this.beanName);
        try (Tracer.SpanInScope spanInScope = this.tracer().withSpan(span.start());){
            this.delegate.run(args);
        }
        finally {
            span.end();
        }
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

