/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.instrument.annotation.AbstractSleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.instrument.annotation.SleuthAnnotationSpan;
import org.springframework.util.StringUtils;

public class NonReactorSleuthMethodInvocationProcessor
extends AbstractSleuthMethodInvocationProcessor {
    public Object process(MethodInvocation invocation, NewSpan newSpan, ContinueSpan continueSpan) throws Throwable {
        return this.proceedUnderSynchronousSpan(invocation, newSpan, continueSpan);
    }

    private Object proceedUnderSynchronousSpan(MethodInvocation invocation, NewSpan newSpan, ContinueSpan continueSpan) throws Throwable {
        boolean startNewSpan;
        Span span = this.tracer().currentSpan();
        boolean bl = startNewSpan = newSpan != null || span == null;
        if (startNewSpan) {
            span = SleuthAnnotationSpan.ANNOTATION_NEW_OR_CONTINUE_SPAN.wrap(this.tracer().nextSpan());
            this.newSpanParser().parse(invocation, newSpan, span);
            span.start();
        }
        String log = this.log(continueSpan);
        boolean hasLog = StringUtils.hasText((String)log);
        try {
            Object object;
            block12: {
                Tracer.SpanInScope scope = this.tracer().withSpan(span);
                try {
                    this.before(invocation, span, log, hasLog);
                    object = invocation.proceed();
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        this.onFailure(span, log, hasLog, ex);
                        throw ex;
                    }
                }
                scope.close();
            }
            return object;
        }
        finally {
            this.after(span, startNewSpan, log, hasLog);
        }
    }
}

