/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.kafka.TracingMessageListenerMethodInterceptor;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;

@Aspect
public class TracingKafkaAspect {
    private static final Log log = LogFactory.getLog(TracingKafkaAspect.class);
    private final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Getter<ConsumerRecord<?, ?>> extractor;

    public TracingKafkaAspect(Tracer tracer, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.extractor = extractor;
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createListenerContainer(..))")
    private void anyCreateListenerContainer() {
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createContainer(..))")
    private void anyCreateContainer() {
    }

    @Around(value="anyCreateListenerContainer() || anyCreateContainer()")
    public Object wrapListenerContainerCreation(ProceedingJoinPoint pjp) throws Throwable {
        MessageListenerContainer listener = (MessageListenerContainer)pjp.proceed();
        if (listener instanceof AbstractMessageListenerContainer) {
            AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listener;
            Object someMessageListener = container.getContainerProperties().getMessageListener();
            if (someMessageListener == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No message listener to wrap. Proceeding");
                }
            } else if (someMessageListener instanceof MessageListener) {
                container.setupMessageListener(this.createProxy(someMessageListener));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"ATM we don't support Batch message listeners");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Can't wrap this listener. Proceeding");
        }
        return listener;
    }

    Object createProxy(Object bean) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(true);
        factory.addAdvice(new TracingMessageListenerMethodInterceptor(this.tracer, this.propagator, this.extractor));
        factory.setTarget(bean);
        return factory.getObject();
    }
}

