/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import java.util.concurrent.ConcurrentHashMap;
import javax.sql.CommonDataSource;

public class DataSourceNameResolver {
    private final ConcurrentHashMap<CommonDataSource, String> cachedNames = new ConcurrentHashMap();

    public void addDataSource(String name, CommonDataSource dataSource) {
        this.cachedNames.put(dataSource, name);
    }

    public String resolveDataSourceName(CommonDataSource dataSource) {
        return this.cachedNames.getOrDefault(dataSource, "dataSource");
    }
}

