/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;

final class SleuthFluxLift<I, O>
extends FluxOperator<I, O>
implements TraceContextPropagator {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

    SleuthFluxLift(Publisher<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        super(Flux.from(p));
        this.lifter = lifter;
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super O> input = actual;
        try {
            input = Objects.requireNonNull(this.lifter.apply((Publisher)this.source, actual), "Lifted subscriber MUST NOT be null");
            this.source.subscribe(input);
        }
        catch (Throwable e) {
            Operators.reportThrowInSubscribe(input, (Throwable)e);
            return;
        }
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

