/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import java.util.function.Function;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import reactor.util.context.Context;

public class BraveContextWrappingFunction
implements Function<Context, Context> {
    @Override
    public Context apply(Context context) {
        Span span = (Span)context.getOrDefault(Span.class, null);
        TraceContext traceContext = (TraceContext)context.getOrDefault(TraceContext.class, null);
        if (span == null && traceContext == null) {
            return context;
        }
        if (context.hasKey(brave.propagation.TraceContext.class)) {
            return context;
        }
        return this.mutateContextWithBrave(context, span, traceContext);
    }

    private Context mutateContextWithBrave(Context context, Span span, TraceContext traceContext) {
        brave.Span braveSpan = BraveSpan.toBrave(span);
        brave.propagation.TraceContext braveTraceContext = BraveTraceContext.toBrave(traceContext);
        Context mutatedContext = context;
        if (braveSpan != null) {
            mutatedContext = context.put(brave.Span.class, (Object)braveSpan);
        }
        if (braveTraceContext != null) {
            mutatedContext = mutatedContext.put(brave.propagation.TraceContext.class, (Object)braveTraceContext);
        }
        return mutatedContext;
    }
}

