/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.jms.JmsTracing;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import org.springframework.beans.factory.BeanFactory;

class LazyConnectionFactory
implements ConnectionFactory {
    private final BeanFactory beanFactory;
    private final ConnectionFactory delegate;
    private JmsTracing jmsTracing;
    private ConnectionFactory wrappedDelegate;

    LazyConnectionFactory(BeanFactory beanFactory, ConnectionFactory delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public Connection createConnection() throws JMSException {
        return this.wrappedDelegate().createConnection();
    }

    public Connection createConnection(String s, String s1) throws JMSException {
        return this.wrappedDelegate().createConnection(s, s1);
    }

    public JMSContext createContext() {
        return this.wrappedDelegate().createContext();
    }

    public JMSContext createContext(String s, String s1) {
        return this.wrappedDelegate().createContext(s, s1);
    }

    public JMSContext createContext(String s, String s1, int i) {
        return this.wrappedDelegate().createContext(s, s1, i);
    }

    public JMSContext createContext(int i) {
        return this.wrappedDelegate().createContext(i);
    }

    private JmsTracing jmsTracing() {
        if (this.jmsTracing != null) {
            return this.jmsTracing;
        }
        this.jmsTracing = (JmsTracing)this.beanFactory.getBean(JmsTracing.class);
        return this.jmsTracing;
    }

    private ConnectionFactory wrappedDelegate() {
        if (this.wrappedDelegate != null) {
            return this.wrappedDelegate;
        }
        this.wrappedDelegate = this.jmsTracing().connectionFactory(this.delegate);
        return this.wrappedDelegate;
    }
}

