/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import zipkin2.reporter.Sender;
import zipkin2.reporter.amqp.RabbitMQSender;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CachingConnectionFactory.class})
@ConditionalOnMissingBean(name={"zipkinSender"})
@Conditional(value={ZipkinSenderCondition.class})
@ConditionalOnProperty(value={"spring.zipkin.sender.type"}, havingValue="rabbit")
class ZipkinRabbitSenderConfiguration {
    @Value(value="${spring.zipkin.rabbitmq.queue:zipkin}")
    private String queue;
    @Value(value="${spring.zipkin.rabbitmq.addresses:}")
    private String addresses;

    ZipkinRabbitSenderConfiguration() {
    }

    @Bean(value={"zipkinSender"})
    Sender rabbitSender(CachingConnectionFactory connectionFactory, RabbitProperties config) {
        String addresses = StringUtils.hasText((String)this.addresses) ? this.addresses : config.determineAddresses();
        return RabbitMQSender.newBuilder().connectionFactory(connectionFactory.getRabbitConnectionFactory()).queue(this.queue).addresses(addresses).build();
    }
}

