/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.kafka;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.kafka.TracingKafkaConsumerFactory;
import org.springframework.cloud.sleuth.instrument.kafka.TracingKafkaProducerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.kafka.receiver.KafkaReceiver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaReceiver.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.kafka.enabled"}, matchIfMissing=true)
public class TracingReactorKafkaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    TracingKafkaProducerFactory tracingKafkaProducerFactory(BeanFactory beanFactory) {
        return new TracingKafkaProducerFactory(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    TracingKafkaConsumerFactory tracingKafkaConsumerFactory(BeanFactory beanFactory) {
        return new TracingKafkaConsumerFactory(beanFactory);
    }
}

