/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.jdbc;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.DataSourceProxyConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.P6SpyConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.TraceDataSourceDecoratorBeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.TraceJdbcProperties;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceDecorator;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceNameResolver;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceHikariListenerStrategySpanCustomizer;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategySpanCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TraceJdbcProperties.class})
@ConditionalOnProperty(name={"spring.sleuth.jdbc.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={DataSource.class, Tracer.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, BraveAutoConfiguration.class})
@Import(value={P6SpyConfiguration.class, DataSourceProxyConfiguration.class})
public class TraceJdbcAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={DataSourceDecorator.class})
    static TraceDataSourceDecoratorBeanPostProcessor traceDataSourceDecoratorBeanPostProcessor(TraceJdbcProperties dataSourceDecoratorProperties) {
        return new TraceDataSourceDecoratorBeanPostProcessor(dataSourceDecoratorProperties.getExcludedDataSourceBeanNames());
    }

    @Bean
    @ConditionalOnMissingBean
    DataSourceNameResolver traceDataSourceNameResolver() {
        return new DataSourceNameResolver();
    }

    @Bean
    @ConditionalOnClass(name={"com.zaxxer.hikari.HikariDataSource"})
    TraceListenerStrategySpanCustomizer hikariTraceListenerStrategySpanCustomizer() {
        return new TraceHikariListenerStrategySpanCustomizer();
    }
}

