/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.jdbc;

import com.p6spy.engine.event.JdbcEventListener;
import com.p6spy.engine.spy.DefaultJdbcEventListenerFactory;
import com.p6spy.engine.spy.JdbcEventListenerFactory;
import com.p6spy.engine.spy.P6DataSource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.P6SpyPropertiesSetter;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.TraceJdbcProperties;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceNameResolver;
import org.springframework.cloud.sleuth.instrument.jdbc.P6SpyContextJdbcEventListenerFactory;
import org.springframework.cloud.sleuth.instrument.jdbc.P6SpyDataSourceDecorator;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceJdbcEventListener;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategySpanCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={P6DataSource.class})
@ConditionalOnProperty(name={"spring.sleuth.jdbc.p6spy.enabled"}, havingValue="true", matchIfMissing=true)
class P6SpyConfiguration {
    P6SpyConfiguration() {
    }

    @Bean
    static P6SpyPropertiesSetter p6SpyPropertiesSetter(ConfigurableApplicationContext context) {
        return new P6SpyPropertiesSetter(context);
    }

    @Bean
    @ConditionalOnMissingBean
    JdbcEventListenerFactory traceJdbcEventListenerFactory(ObjectProvider<List<JdbcEventListener>> listeners) {
        DefaultJdbcEventListenerFactory jdbcEventListenerFactory = new DefaultJdbcEventListenerFactory();
        List listenerList = (List)listeners.getIfAvailable(() -> null);
        return listenerList != null ? new P6SpyContextJdbcEventListenerFactory((JdbcEventListenerFactory)jdbcEventListenerFactory, listenerList) : jdbcEventListenerFactory;
    }

    @Bean
    P6SpyDataSourceDecorator p6SpyDataSourceDecorator(JdbcEventListenerFactory jdbcEventListenerFactory) {
        return new P6SpyDataSourceDecorator(jdbcEventListenerFactory);
    }

    @Bean
    TraceJdbcEventListener tracingJdbcEventListener(Tracer tracer, DataSourceNameResolver dataSourceNameResolver, TraceJdbcProperties traceJdbcProperties, ObjectProvider<List<TraceListenerStrategySpanCustomizer>> customizers) {
        return new TraceJdbcEventListener(tracer, dataSourceNameResolver, traceJdbcProperties.getIncludes(), traceJdbcProperties.getP6spy().getTracing().isIncludeParameterValues(), (List)customizers.getIfAvailable(ArrayList::new));
    }
}

