/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.messaging;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthIntegrationMessagingProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorGetter;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorSetter;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.support.MessageHeaderAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MessageHeaderAccessor.class})
@ConditionalOnProperty(value={"spring.sleuth.messaging.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthIntegrationMessagingProperties.class, SleuthMessagingProperties.class})
class TraceSpringMessagingAutoConfiguration {
    TraceSpringMessagingAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    Propagator.Setter<MessageHeaderAccessor> traceMessagePropagationSetter() {
        return new MessageHeaderPropagatorSetter();
    }

    @Bean
    @ConditionalOnMissingBean
    Propagator.Getter<MessageHeaderAccessor> traceMessagePropagationGetter() {
        return new MessageHeaderPropagatorGetter();
    }
}

