/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.SleuthReactorProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

class HookRegisteringBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Closeable {
    private static final Log log = LogFactory.getLog(HookRegisteringBeanDefinitionRegistryPostProcessor.class);
    final ConfigurableApplicationContext springContext;

    HookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        HookRegisteringBeanDefinitionRegistryPostProcessor.setupHooks(this.springContext);
    }

    static void setupHooks(ConfigurableApplicationContext springContext) {
        ConfigurableEnvironment environment = springContext.getEnvironment();
        SleuthReactorProperties.InstrumentationType property = (SleuthReactorProperties.InstrumentationType)((Object)environment.getProperty("spring.sleuth.reactor.instrumentation-type", SleuthReactorProperties.InstrumentationType.class, (Object)SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH));
        Boolean decorateOnEach = (Boolean)environment.getProperty("spring.sleuth.reactor.decorate-on-each", Boolean.class, (Object)true);
        if (!decorateOnEach.booleanValue()) {
            log.warn((Object)"You're using the deprecated [spring.sleuth.reactor.decorate-on-each] property. Please use the [spring.sleuth.reactor.instrumentation-type] one instead.");
            HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
        } else if (property == SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH) {
            HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnEach(springContext);
        } else if (property == SleuthReactorProperties.InstrumentationType.DECORATE_ON_LAST) {
            HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
        } else if (property == SleuthReactorProperties.InstrumentationType.MANUAL) {
            HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.springContextSpanOperator((ConfigurableApplicationContext)springContext));
        }
    }

    private static void decorateOnLast(Function<? super Publisher<Object>, ? extends Publisher<Object>> function) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating onLast operator instrumentation");
        }
        Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, function);
    }

    private static void decorateOnEach(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating onEach operator instrumentation");
        }
        Hooks.onEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
    }

    @Override
    public void close() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cleaning up hooks");
        }
        Hooks.resetOnEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.resetOnLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Schedulers.removeExecutorServiceDecorator((String)"sleuth");
    }
}

