/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

public class SpanAndScope
implements Closeable {
    private static final Log log = LogFactory.getLog(SpanAndScope.class);
    private final Span span;
    private final Tracer.SpanInScope scope;

    public SpanAndScope(Span span, Tracer.SpanInScope scope) {
        this.span = span;
        this.scope = scope;
    }

    public Span getSpan() {
        return this.span;
    }

    public Tracer.SpanInScope getScope() {
        return this.scope;
    }

    public String toString() {
        return "SpanAndScope{span=" + this.span + '}';
    }

    @Override
    public void close() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Closing span [" + this.span + "]"));
        }
        this.scope.close();
        this.span.end();
    }
}

