/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import java.util.Map;
import java.util.Objects;
import org.springframework.util.Assert;

public class ActuatorPostRequest {
    private String endpoint;
    private Map<String, Object> body;

    public static ActuatorPostRequest of(String endpoint, Map<String, Object> body) {
        Assert.notEmpty(body, (String)"'body' must not be empty");
        ActuatorPostRequest actuatorPostRequest = new ActuatorPostRequest();
        actuatorPostRequest.setEndpoint(endpoint == null ? "/" : endpoint);
        actuatorPostRequest.setBody(body);
        return actuatorPostRequest;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public void setBody(Map<String, Object> body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActuatorPostRequest that = (ActuatorPostRequest)o;
        return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.body);
    }
}

