/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.skipper.client.SkipperClient;
import org.springframework.cloud.skipper.client.SkipperServerException;
import org.springframework.cloud.skipper.domain.AboutResource;
import org.springframework.cloud.skipper.domain.CancelRequest;
import org.springframework.cloud.skipper.domain.CancelResponse;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.cloud.skipper.domain.Info;
import org.springframework.cloud.skipper.domain.InstallRequest;
import org.springframework.cloud.skipper.domain.LogInfo;
import org.springframework.cloud.skipper.domain.Manifest;
import org.springframework.cloud.skipper.domain.PackageMetadata;
import org.springframework.cloud.skipper.domain.Release;
import org.springframework.cloud.skipper.domain.Repository;
import org.springframework.cloud.skipper.domain.RollbackRequest;
import org.springframework.cloud.skipper.domain.ScaleRequest;
import org.springframework.cloud.skipper.domain.Template;
import org.springframework.cloud.skipper.domain.UpgradeRequest;
import org.springframework.cloud.skipper.domain.UploadRequest;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultSkipperClient
implements SkipperClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSkipperClient.class);
    protected final RestTemplate restTemplate;
    private final String baseUri;

    public DefaultSkipperClient(String baseUri) {
        this(baseUri, new RestTemplate());
    }

    public DefaultSkipperClient(String baseUri, RestTemplate restTemplate) {
        Assert.notNull((Object)baseUri, (String)"The provided baseURI must not be null.");
        Assert.notNull((Object)restTemplate, (String)"The provided restTemplate must not be null.");
        this.baseUri = baseUri;
        this.restTemplate = restTemplate;
    }

    @Override
    public Template getSpringCloudDeployerApplicationTemplate() {
        ClassPathResource resource = new ClassPathResource("/org/springframework/cloud/skipper/io/generic-template.yml");
        String genericTempateData = null;
        try {
            genericTempateData = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't load generic template", e);
        }
        Template template = new Template();
        template.setData(genericTempateData);
        try {
            template.setName(resource.getURL().toString());
        }
        catch (IOException e) {
            log.error("Could not get URL of resource " + resource.getDescription(), (Throwable)e);
            throw new SkipperServerException("Could not get URL of resource " + resource.getDescription(), e);
        }
        return template;
    }

    @Override
    public AboutResource info() {
        return (AboutResource)this.restTemplate.getForObject(this.baseUri + "/about", AboutResource.class, new Object[0]);
    }

    @Override
    public Info status(String releaseName) {
        ParameterizedTypeReference<Info> typeReference = new ParameterizedTypeReference<Info>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/status/{releaseName}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return (Info)resourceResponseEntity.getBody();
    }

    @Override
    public Map<String, Info> statuses(String ... releaseNames) {
        ParameterizedTypeReference<Map<String, Info>> typeReference = new ParameterizedTypeReference<Map<String, Info>>(){};
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.baseUri + "/release/statuses"));
        builder.queryParam("names", new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])releaseNames)});
        ResponseEntity responseEntity = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    @Override
    public Map<String, Map<String, DeploymentState>> states(String ... releaseNames) {
        ParameterizedTypeReference<Map<String, Map<String, DeploymentState>>> typeReference = new ParameterizedTypeReference<Map<String, Map<String, DeploymentState>>>(){};
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.baseUri + "/release/states"));
        builder.queryParam("names", new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])releaseNames)});
        ResponseEntity responseEntity = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    @Override
    public Info status(String releaseName, int releaseVersion) {
        ParameterizedTypeReference<Info> typeReference = new ParameterizedTypeReference<Info>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        uriVariables.put("releaseVersion", Integer.toString(releaseVersion));
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/status/{releaseName}/{releaseVersion}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return (Info)resourceResponseEntity.getBody();
    }

    @Override
    public LogInfo getLog(String releaseName) {
        ParameterizedTypeReference<LogInfo> typeReference = new ParameterizedTypeReference<LogInfo>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/logs/{releaseName}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return (LogInfo)resourceResponseEntity.getBody();
    }

    @Override
    public LogInfo getLog(String releaseName, String appName) {
        ParameterizedTypeReference<LogInfo> typeReference = new ParameterizedTypeReference<LogInfo>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        uriVariables.put("appName", appName);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/logs/{releaseName}/{appName}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return (LogInfo)resourceResponseEntity.getBody();
    }

    @Override
    public Release scale(String releaseName, ScaleRequest scaleRequest) {
        ParameterizedTypeReference<Release> typeReference = new ParameterizedTypeReference<Release>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        HttpEntity httpEntity = new HttpEntity((Object)scaleRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/scale/{releaseName}", HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, uriVariables);
        return (Release)resourceResponseEntity.getBody();
    }

    @Override
    public String manifest(String releaseName) {
        ParameterizedTypeReference<Manifest> typeReference = new ParameterizedTypeReference<Manifest>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/manifest/{releaseName}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return ((Manifest)resourceResponseEntity.getBody()).getData();
    }

    @Override
    public String manifest(String releaseName, int releaseVersion) {
        ParameterizedTypeReference<Manifest> typeReference = new ParameterizedTypeReference<Manifest>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        uriVariables.put("releaseVersion", Integer.toString(releaseVersion));
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/manifest/{releaseName}/{releaseVersion}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return ((Manifest)resourceResponseEntity.getBody()).getData();
    }

    @Override
    public Collection<PackageMetadata> search(String name, boolean details) {
        ResponseEntity resourceResponseEntity;
        PackageMetadatasResponseWrapper embedded;
        ParameterizedTypeReference<HateoasResponseWrapper<PackageMetadatasResponseWrapper>> typeReference = new ParameterizedTypeReference<HateoasResponseWrapper<PackageMetadatasResponseWrapper>>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("size", "2000");
        String url = this.baseUri + "/packageMetadata";
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        builder.queryParam("size", new Object[]{"2000"});
        if (StringUtils.hasText((String)name)) {
            uriVariables.put("name", name);
            builder.pathSegment(new String[]{"search", "findByNameContainingIgnoreCase"});
            builder.queryParam("name", new Object[]{name});
        }
        if (!details) {
            builder.queryParam("projection", new Object[]{"summary"});
            builder.queryParam("sort", new Object[]{"name,asc"});
        }
        if ((embedded = (PackageMetadatasResponseWrapper)((HateoasResponseWrapper)(resourceResponseEntity = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables)).getBody()).getEmbedded()) != null) {
            return embedded.getPackageMetadata();
        }
        return Collections.emptyList();
    }

    @Override
    public Release install(InstallRequest installRequest) {
        ParameterizedTypeReference<Release> typeReference = new ParameterizedTypeReference<Release>(){};
        String url = String.format("%s/%s/%s", this.baseUri, "package", "install");
        HttpEntity httpEntity = new HttpEntity((Object)installRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, new Object[0]);
        return (Release)resourceResponseEntity.getBody();
    }

    @Override
    public Release upgrade(UpgradeRequest upgradeRequest) {
        String url = String.format("%s/%s/%s", this.baseUri, "release", "upgrade");
        log.debug("Posting UpgradeRequest to " + url + ". UpgradeRequest = " + upgradeRequest);
        return (Release)this.restTemplate.postForObject(url, (Object)upgradeRequest, Release.class, new Object[0]);
    }

    @Override
    public void delete(String releaseName, boolean deletePackage) {
        String url = null;
        if (deletePackage) {
            url = String.format("%s/%s/%s/%s", this.baseUri, "release", releaseName, "package");
            log.debug("Sending Delete request to " + url + " with the option to delete package");
        } else {
            url = String.format("%s/%s/%s", this.baseUri, "release", releaseName);
        }
        this.restTemplate.delete(url, new Object[]{deletePackage});
    }

    @Override
    public CancelResponse cancel(CancelRequest cancelRequest) {
        String url = String.format("%s/%s/%s", this.baseUri, "release", "cancel");
        log.debug("Posting CancelRequest to " + url + ". CancelRequest = " + cancelRequest);
        return (CancelResponse)this.restTemplate.postForObject(url, (Object)cancelRequest, CancelResponse.class, new Object[0]);
    }

    @Override
    public Release rollback(RollbackRequest rollbackRequest) {
        ParameterizedTypeReference<Release> typeReference = new ParameterizedTypeReference<Release>(){};
        String url = String.format("%s/%s/%s", this.baseUri, "release", "rollback");
        HttpEntity httpEntity = new HttpEntity((Object)rollbackRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, new Object[0]);
        return (Release)resourceResponseEntity.getBody();
    }

    @Override
    public Release rollback(String releaseName, int releaseVersion) {
        return this.rollback(new RollbackRequest(releaseName, Integer.valueOf(releaseVersion)));
    }

    @Override
    public List<Release> list(String releaseNameLike) {
        ParameterizedTypeReference<HateoasResponseWrapper<ReleasesResponseWrapper>> typeReference = new ParameterizedTypeReference<HateoasResponseWrapper<ReleasesResponseWrapper>>(){};
        String url = StringUtils.hasText((String)releaseNameLike) ? String.format("%s/%s/%s/%s", this.baseUri, "release", "list", releaseNameLike) : String.format("%s/%s/%s", this.baseUri, "release", "list");
        ReleasesResponseWrapper embedded = (ReleasesResponseWrapper)((HateoasResponseWrapper)this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new HashMap()).getBody()).getEmbedded();
        if (embedded != null && embedded.getReleases() != null) {
            return embedded.getReleases().stream().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Release> history(String releaseName) {
        ParameterizedTypeReference<HateoasResponseWrapper<ReleasesResponseWrapper>> typeReference = new ParameterizedTypeReference<HateoasResponseWrapper<ReleasesResponseWrapper>>(){};
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.baseUri);
        builder.pathSegment(new String[]{"releases", "search", "findByNameIgnoreCaseContainingOrderByNameAscVersionDesc"});
        builder.queryParam("name", new Object[]{releaseName});
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]);
        ReleasesResponseWrapper embedded = (ReleasesResponseWrapper)((HateoasResponseWrapper)resourceResponseEntity.getBody()).getEmbedded();
        if (embedded != null) {
            return embedded.getReleases();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Repository> listRepositories() {
        ParameterizedTypeReference<HateoasResponseWrapper<RepositoriesResponseWrapper>> typeReference = new ParameterizedTypeReference<HateoasResponseWrapper<RepositoriesResponseWrapper>>(){};
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.baseUri + "/repositories"));
        builder.queryParam("size", new Object[]{"2000"});
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]);
        RepositoriesResponseWrapper embedded = (RepositoriesResponseWrapper)((HateoasResponseWrapper)resourceResponseEntity.getBody()).getEmbedded();
        if (embedded != null) {
            return embedded.getRepositories();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Deployer> listDeployers() {
        ParameterizedTypeReference<HateoasResponseWrapper<DeployersResponseWrapper>> typeReference = new ParameterizedTypeReference<HateoasResponseWrapper<DeployersResponseWrapper>>(){};
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.baseUri + "/deployers"));
        builder.queryParam("size", new Object[]{"2000"});
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]);
        DeployersResponseWrapper embedded = (DeployersResponseWrapper)((HateoasResponseWrapper)resourceResponseEntity.getBody()).getEmbedded();
        if (embedded != null) {
            return embedded.getDeployers();
        }
        return Collections.emptyList();
    }

    @Override
    public PackageMetadata upload(UploadRequest uploadRequest) {
        ParameterizedTypeReference<PackageMetadata> typeReference = new ParameterizedTypeReference<PackageMetadata>(){};
        String url = String.format("%s/%s/%s", this.baseUri, "package", "upload");
        log.debug("Uploading package {}-{} to repository {}.", new Object[]{uploadRequest.getName(), uploadRequest.getVersion(), uploadRequest.getRepoName()});
        HttpEntity httpEntity = new HttpEntity((Object)uploadRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, new Object[0]);
        PackageMetadata packageMetadata = (PackageMetadata)resourceResponseEntity.getBody();
        return packageMetadata;
    }

    @Override
    public void packageDelete(String packageName) {
        String url = String.format("%s/%s/%s", this.baseUri, "package", packageName);
        this.restTemplate.delete(url, new Object[0]);
    }

    protected static class ReleasesResponseWrapper {
        private Collection<Release> releases;

        protected ReleasesResponseWrapper() {
        }

        public void setReleases(Collection<Release> releases) {
            this.releases = releases;
        }

        public Collection<Release> getReleases() {
            return this.releases;
        }
    }

    protected static class PackageMetadatasResponseWrapper {
        private Collection<PackageMetadata> packageMetadata;

        protected PackageMetadatasResponseWrapper() {
        }

        public void setPackageMetadata(Collection<PackageMetadata> packageMetadata) {
            this.packageMetadata = packageMetadata;
        }

        public Collection<PackageMetadata> getPackageMetadata() {
            return this.packageMetadata;
        }
    }

    protected static class DeployersResponseWrapper {
        private Collection<Deployer> deployers;

        protected DeployersResponseWrapper() {
        }

        public void setDeployers(Collection<Deployer> deployers) {
            this.deployers = deployers;
        }

        public Collection<Deployer> getDeployers() {
            return this.deployers;
        }
    }

    protected static class RepositoriesResponseWrapper {
        private Collection<Repository> repositories;

        protected RepositoriesResponseWrapper() {
        }

        public void setRepositories(Collection<Repository> repositories) {
            this.repositories = repositories;
        }

        public Collection<Repository> getRepositories() {
            return this.repositories;
        }
    }

    protected static class HateoasResponseWrapper<T> {
        private T embedded;

        protected HateoasResponseWrapper() {
        }

        public void setEmbedded(T embedded) {
            this.embedded = embedded;
        }

        @JsonProperty(value="_embedded")
        public T getEmbedded() {
            return this.embedded;
        }
    }
}

