/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.client;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2AutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OAuth2RestTemplate.class})
@ConditionalOnProperty(value={"security.oauth2.resource.loadBalanced"}, matchIfMissing=false)
@AutoConfigureAfter(value={OAuth2AutoConfiguration.class})
public class OAuth2LoadBalancerClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={RetryLoadBalancerInterceptor.class})
    protected static class UserInfoRetryLoadBalancerConfig {
        protected UserInfoRetryLoadBalancerConfig() {
        }

        @Bean
        public UserInfoRestTemplateCustomizer retryLoadBalancedUserInfoRestTemplateCustomizer(final RetryLoadBalancerInterceptor loadBalancerInterceptor) {
            return new UserInfoRestTemplateCustomizer(){

                public void customize(OAuth2RestTemplate restTemplate) {
                    ArrayList<RetryLoadBalancerInterceptor> interceptors = new ArrayList<RetryLoadBalancerInterceptor>(restTemplate.getInterceptors());
                    interceptors.add(loadBalancerInterceptor);
                    restTemplate.setInterceptors(interceptors);
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={LoadBalancerInterceptor.class})
    protected static class UserInfoLoadBalancerConfig {
        protected UserInfoLoadBalancerConfig() {
        }

        @Bean
        public UserInfoRestTemplateCustomizer loadBalancedUserInfoRestTemplateCustomizer(final LoadBalancerInterceptor loadBalancerInterceptor) {
            return new UserInfoRestTemplateCustomizer(){

                public void customize(OAuth2RestTemplate restTemplate) {
                    ArrayList<LoadBalancerInterceptor> interceptors = new ArrayList<LoadBalancerInterceptor>(restTemplate.getInterceptors());
                    interceptors.add(loadBalancerInterceptor);
                    restTemplate.setInterceptors(interceptors);
                }
            };
        }
    }
}

