/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="proxy.auth")
public class ProxyAuthenticationProperties {
    private Map<String, Route> routes = new HashMap<String, Route>();
    private boolean loadBalanced;

    @PostConstruct
    public void init() {
        for (Map.Entry<String, Route> entry : this.routes.entrySet()) {
            if (entry.getValue().getId() != null) continue;
            entry.getValue().setId(entry.getKey());
        }
    }

    public Map<String, Route> getRoutes() {
        return this.routes;
    }

    public void setRoutes(Map<String, Route> routes) {
        this.routes = routes;
    }

    public boolean isLoadBalanced() {
        return this.loadBalanced;
    }

    public void setLoadBalanced(boolean loadBalanced) {
        this.loadBalanced = loadBalanced;
    }

    public static class Route {
        private String id;
        private String scheme;

        public Route(String scheme) {
            this.scheme = scheme;
        }

        public String getId() {
            return this.id;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Route)) {
                return false;
            }
            Route other = (Route)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$scheme = this.getScheme();
            String other$scheme = other.getScheme();
            return !(this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Route;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $scheme = this.getScheme();
            result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
            return result;
        }

        public String toString() {
            return "ProxyAuthenticationProperties.Route(id=" + this.getId() + ", scheme=" + this.getScheme() + ")";
        }

        public static class Scheme {
            public static final Scheme OAUTH2 = new Scheme("oauth2");
            public static final Scheme PASSTHRU = new Scheme("passthru");
            public static final Scheme NONE = new Scheme("none");
            private final String value;

            private Scheme(String value) {
                this.value = value;
            }

            public boolean matches(String value) {
                return value != null && value.equals(this.value);
            }
        }
    }
}

