/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.resource;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;

public class UserInfoTokenServices
implements ResourceServerTokenServices {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String userInfoEndpointUrl;
    private String clientId;
    private OAuth2RestOperations restTemplate;

    public UserInfoTokenServices(String userInfoEndpointUrl, String clientId) {
        this.userInfoEndpointUrl = userInfoEndpointUrl;
        this.clientId = clientId;
    }

    public void setRestTemplate(OAuth2RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Map<String, Object> map = this.getMap(this.userInfoEndpointUrl, accessToken);
        if (map.containsKey("error")) {
            this.logger.debug((Object)("userinfo returned error: " + map.get("error")));
            throw new InvalidTokenException(accessToken);
        }
        return this.extractAuthentication(map);
    }

    private OAuth2Authentication extractAuthentication(Map<String, Object> map) {
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken(this.getPrincipal(map), (Object)"N/A", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
        user.setDetails(map);
        OAuth2Request request = new OAuth2Request(null, this.clientId, null, true, null, null, null, null, null);
        return new OAuth2Authentication(request, (Authentication)user);
    }

    private Object getPrincipal(Map<String, Object> map) {
        String[] keys;
        for (String key : keys = new String[]{"user", "username", "userid", "user_id", "login", "id", "name"}) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return "unknown";
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }

    private Map<String, Object> getMap(String path, String accessToken) {
        Map map;
        this.logger.info((Object)("Getting user info from: " + path));
        OAuth2RestOperations restTemplate = this.restTemplate;
        if (restTemplate == null) {
            BaseOAuth2ProtectedResourceDetails resource = new BaseOAuth2ProtectedResourceDetails();
            resource.setClientId(this.clientId);
            restTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resource);
        }
        restTemplate.getOAuth2ClientContext().setAccessToken((OAuth2AccessToken)new DefaultOAuth2AccessToken(accessToken));
        Map result = map = (Map)restTemplate.getForEntity(path, Map.class, new Object[0]).getBody();
        return result;
    }
}

