/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.reactive;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.springframework.cloud.servicebroker.exception.ServiceBrokerApiVersionErrorMessage;
import org.springframework.cloud.servicebroker.model.BrokerApiVersion;
import org.springframework.cloud.servicebroker.model.error.ErrorMessage;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ApiVersionWebFilter
implements WebFilter {
    private static final String V2_API_PATH_PATTERN = "/v2/**";
    private final BrokerApiVersion version;

    public ApiVersionWebFilter() {
        this(null);
    }

    public ApiVersionWebFilter(BrokerApiVersion version) {
        this.version = version;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        PathPattern p = new PathPatternParser().parse(V2_API_PATH_PATTERN);
        Mono filterMono = chain.filter(exchange);
        if (p.matches((PathContainer)exchange.getRequest().getPath()) && this.version != null && !this.anyVersionAllowed()) {
            String apiVersion = exchange.getRequest().getHeaders().getFirst(this.version.getBrokerApiVersionHeader());
            ServerHttpResponse response = exchange.getResponse();
            String message = null;
            if (apiVersion == null) {
                response.setStatusCode(HttpStatus.BAD_REQUEST);
                message = ServiceBrokerApiVersionErrorMessage.from((String)this.version.getApiVersion(), (String)"null").toString();
            } else if (!this.version.getApiVersion().equals(apiVersion)) {
                response.setStatusCode(HttpStatus.PRECONDITION_FAILED);
                message = ServiceBrokerApiVersionErrorMessage.from((String)this.version.getApiVersion(), (String)apiVersion).toString();
            }
            if (message != null) {
                String json;
                try {
                    json = new ObjectMapper().writeValueAsString((Object)new ErrorMessage(message));
                }
                catch (JsonProcessingException e) {
                    json = "{}";
                }
                Flux responseBody = Flux.just((Object)json).map(s -> this.toDataBuffer((String)s, response.bufferFactory()));
                filterMono = response.writeWith((Publisher)responseBody);
            }
        }
        return filterMono;
    }

    private boolean anyVersionAllowed() {
        return "*".equals(this.version.getApiVersion());
    }

    private DataBuffer toDataBuffer(String value, DataBufferFactory factory) {
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = factory.allocateBuffer(data.length);
        buffer.write(data);
        return buffer;
    }
}

