/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.servicebroker.autoconfigure.web.util.MetadataUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ServiceMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMetadata.class);
    private static final String DISPLAY_NAME_KEY = "displayName";
    private static final String IMAGE_URL_KEY = "imageUrl";
    private static final String LONG_DESCRIPTION_KEY = "longDescription";
    private static final String PROVIDER_DISPLAY_NAME_KEY = "providerDisplayName";
    private static final String DOCUMENTATION_URL_KEY = "documentationUrl";
    private static final String SUPPORT_URL_KEY = "supportUrl";
    private static final String IMAGE_DATA_FORMAT = "data:image/png;base64,%s";
    private String displayName;
    private String imageUrl;
    private String imageUrlResource;
    private String longDescription;
    private String providerDisplayName;
    private String documentationUrl;
    private String supportUrl;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getImageUrlResource() {
        return this.imageUrlResource;
    }

    public void setImageUrlResource(String imageUrlResource) {
        this.imageUrlResource = imageUrlResource;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getProviderDisplayName() {
        return this.providerDisplayName;
    }

    public void setProviderDisplayName(String providerDisplayName) {
        this.providerDisplayName = providerDisplayName;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (!CollectionUtils.isEmpty(properties)) {
            this.properties.putAll(properties);
        }
    }

    public Map<String, Object> toModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (StringUtils.hasText((String)this.displayName)) {
            model.put(DISPLAY_NAME_KEY, this.displayName);
        }
        if (StringUtils.hasText((String)this.imageUrl)) {
            model.put(IMAGE_URL_KEY, this.imageUrl);
        } else if (StringUtils.hasText((String)this.imageUrlResource)) {
            model.put(IMAGE_URL_KEY, this.base64EncodeImageData(this.imageUrlResource));
        }
        if (StringUtils.hasText((String)this.longDescription)) {
            model.put(LONG_DESCRIPTION_KEY, this.longDescription);
        }
        if (StringUtils.hasText((String)this.providerDisplayName)) {
            model.put(PROVIDER_DISPLAY_NAME_KEY, this.providerDisplayName);
        }
        if (StringUtils.hasText((String)this.documentationUrl)) {
            model.put(DOCUMENTATION_URL_KEY, this.documentationUrl);
        }
        if (StringUtils.hasText((String)this.supportUrl)) {
            model.put(SUPPORT_URL_KEY, this.supportUrl);
        }
        if (!CollectionUtils.isEmpty(this.properties)) {
            model.putAll(MetadataUtils.convertMap(this.properties));
        }
        return model;
    }

    private String base64EncodeImageData(String filename) {
        String formattedImageData = null;
        ClassPathResource resource = new ClassPathResource(filename);
        try (InputStream stream = resource.getInputStream();){
            byte[] imageBytes = StreamUtils.copyToByteArray((InputStream)stream);
            String imageData = Base64Utils.encodeToString((byte[])imageBytes);
            formattedImageData = String.format(IMAGE_DATA_FORMAT, imageData);
        }
        catch (IOException e) {
            LOG.warn("Error converting image file to byte array", (Throwable)e);
        }
        return formattedImageData;
    }
}

