/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.servlet;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.cloud.servicebroker.autoconfigure.web.ServiceBrokerAutoConfiguration;
import org.springframework.cloud.servicebroker.autoconfigure.web.exception.ServiceInstanceServiceBeanDoesNotExistException;
import org.springframework.cloud.servicebroker.controller.CatalogController;
import org.springframework.cloud.servicebroker.controller.ServiceBrokerExceptionHandler;
import org.springframework.cloud.servicebroker.controller.ServiceInstanceBindingController;
import org.springframework.cloud.servicebroker.controller.ServiceInstanceController;
import org.springframework.cloud.servicebroker.service.CatalogService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceBindingEventService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceEventService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.cloud.servicebroker.service.events.EventFlowRegistries;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, ServiceBrokerAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServiceBrokerWebMvcAutoConfiguration {
    private final CatalogService catalogService;
    private final ServiceInstanceEventService serviceInstanceEventService;
    private final ServiceInstanceBindingEventService serviceInstanceBindingEventService;

    protected ServiceBrokerWebMvcAutoConfiguration(CatalogService catalogService, @Autowired(required=false) ServiceInstanceService serviceInstanceService, ServiceInstanceBindingService serviceInstanceBindingService, EventFlowRegistries eventFlowRegistries) {
        if (serviceInstanceService == null) {
            throw new ServiceInstanceServiceBeanDoesNotExistException();
        }
        this.catalogService = catalogService;
        this.serviceInstanceEventService = new ServiceInstanceEventService(serviceInstanceService, eventFlowRegistries);
        this.serviceInstanceBindingEventService = new ServiceInstanceBindingEventService(serviceInstanceBindingService, eventFlowRegistries);
    }

    @Bean
    public CatalogController catalogController() {
        return new CatalogController(this.catalogService);
    }

    @Bean
    public ServiceInstanceController serviceInstanceController() {
        return new ServiceInstanceController(this.catalogService, (ServiceInstanceService)this.serviceInstanceEventService);
    }

    @Bean
    public ServiceInstanceBindingController serviceInstanceBindingController() {
        return new ServiceInstanceBindingController(this.catalogService, (ServiceInstanceBindingService)this.serviceInstanceBindingEventService);
    }

    @Bean
    public ServiceBrokerExceptionHandler serviceBrokerExceptionHandler() {
        return new ServiceBrokerExceptionHandler();
    }
}

