/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.servicebroker.autoconfigure.web.ServiceBrokerProperties;
import org.springframework.cloud.servicebroker.model.catalog.Catalog;
import org.springframework.cloud.servicebroker.service.BeanCatalogService;
import org.springframework.cloud.servicebroker.service.CatalogService;
import org.springframework.cloud.servicebroker.service.NonBindableServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ServiceInstanceService.class})
@EnableConfigurationProperties(value={ServiceBrokerProperties.class})
public class ServiceBrokerAutoConfiguration {
    private final ServiceBrokerProperties serviceBrokerProperties;

    public ServiceBrokerAutoConfiguration(ServiceBrokerProperties serviceBrokerProperties) {
        this.serviceBrokerProperties = serviceBrokerProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={Catalog.class})
    @ConditionalOnProperty(prefix="spring.cloud.openservicebroker.catalog.services[0]", name={"id"})
    public Catalog catalog() {
        return this.serviceBrokerProperties.getCatalog().toModel();
    }

    @Bean
    @ConditionalOnMissingBean(value={CatalogService.class})
    @ConditionalOnBean(value={Catalog.class})
    public CatalogService beanCatalogService(Catalog catalog) {
        return new BeanCatalogService(catalog);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceBindingService.class})
    public ServiceInstanceBindingService nonBindableServiceInstanceBindingService() {
        return new NonBindableServiceInstanceBindingService();
    }
}

