/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.turbine.data.AggDataFromCluster;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.handler.PerformanceCriteria;
import com.netflix.turbine.handler.TurbineDataHandler;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.AggregateClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.turbine.SpringClusterMonitor;
import org.springframework.cloud.netflix.turbine.TurbineClustersProvider;

public class SpringAggregatorFactory
implements ClusterMonitorFactory<AggDataFromCluster> {
    private static final Log log = LogFactory.getLog(SpringAggregatorFactory.class);
    private final TurbineClustersProvider clustersProvider;
    private TurbineDataHandler<AggDataFromCluster> StaticListener = new TurbineDataHandler<AggDataFromCluster>(){

        public String getName() {
            return "StaticListener_For_Aggregator";
        }

        public void handleData(Collection<AggDataFromCluster> stats) {
        }

        public void handleHostLost(Instance host) {
        }

        public PerformanceCriteria getCriteria() {
            return SpringAggregatorFactory.this.NonCriticalCriteria;
        }
    };
    private PerformanceCriteria NonCriticalCriteria = new PerformanceCriteria(){

        public boolean isCritical() {
            return false;
        }

        public int getMaxQueueSize() {
            return 0;
        }

        public int numThreads() {
            return 0;
        }
    };

    public SpringAggregatorFactory(TurbineClustersProvider clustersProvider) {
        this.clustersProvider = clustersProvider;
    }

    public ClusterMonitor<AggDataFromCluster> getClusterMonitor(String name) {
        TurbineDataMonitor clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findMonitor(name + "_agg");
        return (ClusterMonitor)clusterMonitor;
    }

    public static TurbineDataMonitor<AggDataFromCluster> findOrRegisterAggregateMonitor(String clusterName) {
        Object clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findMonitor(clusterName + "_agg");
        if (clusterMonitor == null) {
            log.info((Object)("Could not find monitors: " + AggregateClusterMonitor.AggregatorClusterMonitorConsole.toString()));
            clusterMonitor = new SpringClusterMonitor(clusterName + "_agg", clusterName);
            clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findOrRegisterMonitor(clusterMonitor);
        }
        return clusterMonitor;
    }

    public void initClusterMonitors() {
        for (String clusterName : this.clustersProvider.getClusterNames()) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)SpringAggregatorFactory.findOrRegisterAggregateMonitor(clusterName);
            clusterMonitor.registerListenertoClusterMonitor(this.StaticListener);
            try {
                clusterMonitor.startMonitor();
            }
            catch (Exception ex) {
                log.warn((Object)("Could not init cluster monitor for: " + clusterName));
                clusterMonitor.stopMonitor();
                clusterMonitor.getDispatcher().stopDispatcher();
            }
        }
    }

    public void shutdownClusterMonitors() {
        for (String clusterName : this.clustersProvider.getClusterNames()) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)AggregateClusterMonitor.findOrRegisterAggregateMonitor((String)clusterName);
            clusterMonitor.stopMonitor();
            clusterMonitor.getDispatcher().stopDispatcher();
        }
    }
}

