/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.init.TurbineInit;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import com.netflix.turbine.plugins.PluginsFactory;
import org.springframework.cloud.netflix.turbine.SpringAggregatorFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.Ordered;

public class TurbineLifecycle
implements SmartLifecycle,
Ordered {
    private final InstanceDiscovery instanceDiscovery;
    private boolean running;

    public TurbineLifecycle(InstanceDiscovery instanceDiscovery) {
        this.instanceDiscovery = instanceDiscovery;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public void start() {
        PluginsFactory.setClusterMonitorFactory((ClusterMonitorFactory)new SpringAggregatorFactory());
        PluginsFactory.setInstanceDiscovery((InstanceDiscovery)this.instanceDiscovery);
        TurbineInit.init();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public int getOrder() {
        return -1;
    }
}

