/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.discovery.EurekaClient;
import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.streaming.servlet.TurbineStreamServlet;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.turbine.CommonsInstanceDiscovery;
import org.springframework.cloud.netflix.turbine.EurekaInstanceDiscovery;
import org.springframework.cloud.netflix.turbine.TurbineLifecycle;
import org.springframework.cloud.netflix.turbine.TurbineProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@EnableDiscoveryClient
public class TurbineHttpConfiguration {
    @Bean
    public HasFeatures Feature() {
        return HasFeatures.namedFeature((String)"Turbine (HTTP)", TurbineHttpConfiguration.class);
    }

    @Bean
    public ServletRegistrationBean turbineStreamServlet() {
        return new ServletRegistrationBean((Servlet)new TurbineStreamServlet(), new String[]{"/turbine.stream"});
    }

    @Bean
    public TurbineProperties turbineProperties() {
        return new TurbineProperties();
    }

    @Bean
    public TurbineLifecycle turbineLifecycle(InstanceDiscovery instanceDiscovery) {
        return new TurbineLifecycle(instanceDiscovery);
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.netflix.discovery.EurekaClient"})
    protected static class DiscoveryClientTurbineConfiguration {
        protected DiscoveryClientTurbineConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public InstanceDiscovery instanceDiscovery(TurbineProperties turbineProperties, DiscoveryClient discoveryClient) {
            return new CommonsInstanceDiscovery(turbineProperties, discoveryClient);
        }
    }

    @Configuration
    @ConditionalOnClass(value={EurekaClient.class})
    protected static class EurekaTurbineConfiguration {
        protected EurekaTurbineConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public InstanceDiscovery instanceDiscovery(TurbineProperties turbineProperties, EurekaClient eurekaClient) {
            return new EurekaInstanceDiscovery(turbineProperties, eurekaClient);
        }
    }
}

