/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAffinityServerListFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ZonePreferenceServerListFilter
extends ZoneAffinityServerListFilter<Server> {
    private String zone;

    public void initWithNiwsConfig(IClientConfig niwsClientConfig) {
        super.initWithNiwsConfig(niwsClientConfig);
        if (ConfigurationManager.getDeploymentContext() != null) {
            this.zone = ConfigurationManager.getDeploymentContext().getValue(DeploymentContext.ContextKey.zone);
        }
    }

    public List<Server> getFilteredListOfServers(List<Server> servers) {
        List output = super.getFilteredListOfServers(servers);
        if (this.zone != null && output.size() == servers.size()) {
            ArrayList<Server> local = new ArrayList<Server>();
            for (Server server : output) {
                if (!this.zone.equalsIgnoreCase(server.getZone())) continue;
                local.add(server);
            }
            if (!local.isEmpty()) {
                return local;
            }
        }
        return output;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ZonePreferenceServerListFilter that = (ZonePreferenceServerListFilter)((Object)o);
        return Objects.equals(this.zone, that.zone);
    }

    public int hashCode() {
        return Objects.hash(this.zone);
    }

    public String toString() {
        return "ZonePreferenceServerListFilter{" + "zone='" + this.zone + "'" + "}";
    }
}

