/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.Server;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.BooleanUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.RibbonRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonProperties;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.HttpClientStatusCodeException;
import org.springframework.cloud.netflix.ribbon.apache.HttpClientUtils;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryListener;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RetryableRibbonLoadBalancingHttpClient
extends RibbonLoadBalancingHttpClient
implements ServiceInstanceChooser {
    private LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory = new LoadBalancedRetryPolicyFactory.NeverRetryFactory();
    private LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory = new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory();
    private LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();

    @Deprecated
    public RetryableRibbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        super(config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
    }

    @Deprecated
    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
    }

    @Deprecated
    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory;
    }

    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory, LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryPolicyFactory = loadBalancedRetryPolicyFactory;
        this.loadBalancedBackOffPolicyFactory = loadBalancedBackOffPolicyFactory;
        this.loadBalancedRetryListenerFactory = loadBalancedRetryListenerFactory;
    }

    @Override
    public RibbonApacheHttpResponse execute(RibbonApacheHttpRequest request, IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        IClientConfig config = configOverride != null ? configOverride : this.config;
        RibbonProperties ribbon = RibbonProperties.from(config);
        builder.setConnectTimeout(ribbon.connectTimeout(this.connectTimeout));
        builder.setSocketTimeout(ribbon.readTimeout(this.readTimeout));
        builder.setRedirectsEnabled(ribbon.isFollowRedirects(this.followRedirects));
        RequestConfig requestConfig = builder.build();
        LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryPolicyFactory.create(this.getClientName(), (ServiceInstanceChooser)this);
        RetryCallback retryCallback = context -> {
            HttpUriRequest httpUriRequest;
            CloseableHttpResponse httpResponse;
            ServiceInstance service;
            RibbonApacheHttpRequest newRequest = request;
            if (context instanceof LoadBalancedRetryContext && (service = ((LoadBalancedRetryContext)context).getServiceInstance()) != null) {
                newRequest = newRequest.withNewUri(UriComponentsBuilder.newInstance().host(service.getHost()).scheme(service.getUri().getScheme()).userInfo(newRequest.getURI().getUserInfo()).port(service.getPort()).path(newRequest.getURI().getPath()).query(newRequest.getURI().getQuery()).fragment(newRequest.getURI().getFragment()).build().encode().toUri());
            }
            if (retryPolicy.retryableStatusCode((httpResponse = ((CloseableHttpClient)this.delegate).execute(httpUriRequest = (newRequest = this.getSecureRequest(newRequest, configOverride)).toRequest(requestConfig))).getStatusLine().getStatusCode())) {
                throw new HttpClientStatusCodeException(this.clientName, (HttpResponse)httpResponse, HttpClientUtils.createEntity((HttpResponse)httpResponse), httpUriRequest.getURI());
            }
            return new RibbonApacheHttpResponse((HttpResponse)httpResponse, httpUriRequest.getURI());
        };
        RibbonRecoveryCallback<RibbonApacheHttpResponse, HttpResponse> recoveryCallback = new RibbonRecoveryCallback<RibbonApacheHttpResponse, HttpResponse>(){

            protected RibbonApacheHttpResponse createResponse(HttpResponse response, URI uri) {
                return new RibbonApacheHttpResponse(response, uri);
            }
        };
        return this.executeWithRetry(request, retryPolicy, (RetryCallback<RibbonApacheHttpResponse, IOException>)retryCallback, (RecoveryCallback<RibbonApacheHttpResponse>)recoveryCallback);
    }

    @Override
    public boolean isClientRetryable(ContextAwareRequest request) {
        return request != null && this.isRequestRetryable(request);
    }

    private boolean isRequestRetryable(ContextAwareRequest request) {
        return request.getContext() == null ? true : BooleanUtils.toBooleanDefaultIfNull((Boolean)request.getContext().getRetryable(), (boolean)true);
    }

    private RibbonApacheHttpResponse executeWithRetry(RibbonApacheHttpRequest request, LoadBalancedRetryPolicy retryPolicy, RetryCallback<RibbonApacheHttpResponse, IOException> callback, RecoveryCallback<RibbonApacheHttpResponse> recoveryCallback) throws Exception {
        RetryTemplate retryTemplate = new RetryTemplate();
        boolean retryable = this.isRequestRetryable(request);
        retryTemplate.setRetryPolicy((org.springframework.retry.RetryPolicy)(retryPolicy == null || !retryable ? new NeverRetryPolicy() : new RetryPolicy(request, retryPolicy, this, this.getClientName())));
        BackOffPolicy backOffPolicy = this.loadBalancedBackOffPolicyFactory.createBackOffPolicy(this.getClientName());
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryListenerFactory.createRetryListeners(this.getClientName());
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        return (RibbonApacheHttpResponse)retryTemplate.execute(callback, recoveryCallback);
    }

    public ServiceInstance choose(String serviceId) {
        Server server = this.getLoadBalancer().chooseServer((Object)serviceId);
        return new RibbonLoadBalancerClient.RibbonServer(serviceId, server);
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonApacheHttpRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, RetryHandler.DEFAULT, null);
    }

    static class RetryPolicy
    extends InterceptorRetryPolicy {
        public RetryPolicy(HttpRequest request, LoadBalancedRetryPolicy policy, ServiceInstanceChooser serviceInstanceChooser, String serviceName) {
            super(request, policy, serviceInstanceChooser, serviceName);
        }
    }
}

