/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.netflix.hystrix.HystrixCircuitBreakerFactory;
import org.springframework.cloud.netflix.hystrix.ReactiveHystrixCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Hystrix.class})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.hystrix.enabled"}, matchIfMissing=true)
public class HystrixCircuitBreakerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public CircuitBreakerFactory hystrixCircuitBreakerFactory() {
        return new HystrixCircuitBreakerFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
    public ReactiveHystrixCircuitBreakerFactory reactiveHystrixCircuitBreakerFactory() {
        return new ReactiveHystrixCircuitBreakerFactory();
    }

    @Configuration
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
    protected static class ReactiveHystrixCircuitBreakerCustomizerConfiguration {
        @Autowired(required=false)
        private List<Customizer<ReactiveHystrixCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactiveHystrixCircuitBreakerFactory>>();
        @Autowired(required=false)
        private ReactiveHystrixCircuitBreakerFactory factory;

        protected ReactiveHystrixCircuitBreakerCustomizerConfiguration() {
        }

        @PostConstruct
        public void init() {
            this.customizers.forEach(customizer -> customizer.customize((Object)this.factory));
        }
    }

    @Configuration
    protected static class HystrixCircuitBreakerCustomizerConfiguration {
        @Autowired(required=false)
        private List<Customizer<HystrixCircuitBreakerFactory>> customizers = new ArrayList<Customizer<HystrixCircuitBreakerFactory>>();
        @Autowired(required=false)
        private HystrixCircuitBreakerFactory factory;

        protected HystrixCircuitBreakerCustomizerConfiguration() {
        }

        @PostConstruct
        public void init() {
            this.customizers.forEach(customizer -> customizer.customize((Object)this.factory));
        }
    }
}

