/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.EurekaJacksonCodec;
import com.netflix.discovery.converters.wrappers.CodecWrapper;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey3.Jersey3TransportClientFactories;
import com.netflix.eureka.DefaultEurekaServerContext;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.DefaultServerCodecs;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import com.netflix.eureka.transport.Jersey3EurekaServerHttpClientFactory;
import com.netflix.eureka.transport.Jersey3ReplicationClient;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jvnet.hk2.spring.bridge.api.SpringBridge;
import org.jvnet.hk2.spring.bridge.api.SpringIntoHK2Bridge;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.eureka.server.CloudJacksonJson;
import org.springframework.cloud.netflix.eureka.server.EurekaController;
import org.springframework.cloud.netflix.eureka.server.EurekaDashboardProperties;
import org.springframework.cloud.netflix.eureka.server.EurekaProperties;
import org.springframework.cloud.netflix.eureka.server.EurekaServerBootstrap;
import org.springframework.cloud.netflix.eureka.server.EurekaServerConfigBean;
import org.springframework.cloud.netflix.eureka.server.EurekaServerInitializerConfiguration;
import org.springframework.cloud.netflix.eureka.server.EurekaServerMarkerConfiguration;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistry;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistryProperties;
import org.springframework.cloud.netflix.eureka.server.ReplicationClientAdditionalFilters;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@Import(value={EurekaServerInitializerConfiguration.class})
@ConditionalOnBean(value={EurekaServerMarkerConfiguration.Marker.class})
@EnableConfigurationProperties(value={EurekaDashboardProperties.class, InstanceRegistryProperties.class, EurekaProperties.class})
@PropertySource(value={"classpath:/eureka/server.properties"})
public class EurekaServerAutoConfiguration
implements WebMvcConfigurer {
    private static final String[] EUREKA_PACKAGES = new String[]{"com.netflix.discovery", "com.netflix.eureka"};
    private static final String STATIC_CONTENT_PATTERN = "/(fonts|images|css|js)/.*";
    @Autowired
    private ApplicationInfoManager applicationInfoManager;
    @Autowired
    private EurekaServerConfig eurekaServerConfig;
    @Autowired
    private EurekaClientConfig eurekaClientConfig;
    @Autowired
    private EurekaClient eurekaClient;
    @Autowired
    private InstanceRegistryProperties instanceRegistryProperties;
    public static final CloudJacksonJson JACKSON_JSON = new CloudJacksonJson();

    @Bean
    public HasFeatures eurekaServerFeature() {
        return HasFeatures.namedFeature((String)"Eureka Server", EurekaServerAutoConfiguration.class);
    }

    @Bean
    @ConditionalOnProperty(prefix="eureka.dashboard", name={"enabled"}, matchIfMissing=true)
    public EurekaController eurekaController(EurekaProperties eurekaProperties) {
        return new EurekaController(this.applicationInfoManager, eurekaProperties);
    }

    @Bean
    public ServerCodecs serverCodecs() {
        return new CloudServerCodecs(this.eurekaServerConfig);
    }

    private static CodecWrapper getFullJson(EurekaServerConfig serverConfig) {
        CodecWrapper codec = CodecWrappers.getCodec((String)serverConfig.getJsonCodecName());
        return codec == null ? CodecWrappers.getCodec((String)JACKSON_JSON.codecName()) : codec;
    }

    private static CodecWrapper getFullXml(EurekaServerConfig serverConfig) {
        CodecWrapper codec = CodecWrappers.getCodec((String)serverConfig.getXmlCodecName());
        return codec == null ? CodecWrappers.getCodec(CodecWrappers.XStreamXml.class) : codec;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReplicationClientAdditionalFilters replicationClientAdditionalFilters() {
        return new ReplicationClientAdditionalFilters(Collections.emptySet());
    }

    @Bean
    @ConditionalOnMissingBean(value={TransportClientFactories.class})
    public Jersey3TransportClientFactories jersey3TransportClientFactories() {
        return Jersey3TransportClientFactories.getInstance();
    }

    @Bean
    public Jersey3EurekaServerHttpClientFactory jersey3EurekaServerHttpClientFactory() {
        return new Jersey3EurekaServerHttpClientFactory();
    }

    @Bean
    public PeerAwareInstanceRegistry peerAwareInstanceRegistry(ServerCodecs serverCodecs, EurekaServerHttpClientFactory eurekaServerHttpClientFactory) {
        this.eurekaClient.getApplications();
        return new InstanceRegistry(this.eurekaServerConfig, this.eurekaClientConfig, serverCodecs, this.eurekaClient, eurekaServerHttpClientFactory, this.instanceRegistryProperties.getExpectedNumberOfClientsSendingRenews(), this.instanceRegistryProperties.getDefaultOpenForTrafficCount());
    }

    @Bean
    @ConditionalOnMissingBean
    public PeerEurekaNodes peerEurekaNodes(PeerAwareInstanceRegistry registry, ServerCodecs serverCodecs, ReplicationClientAdditionalFilters replicationClientAdditionalFilters) {
        return new RefreshablePeerEurekaNodes(registry, this.eurekaServerConfig, this.eurekaClientConfig, serverCodecs, this.applicationInfoManager, replicationClientAdditionalFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    public EurekaServerContext eurekaServerContext(ServerCodecs serverCodecs, PeerAwareInstanceRegistry registry, PeerEurekaNodes peerEurekaNodes) {
        return new DefaultEurekaServerContext(this.eurekaServerConfig, serverCodecs, registry, peerEurekaNodes, this.applicationInfoManager);
    }

    @Bean
    public EurekaServerBootstrap eurekaServerBootstrap(PeerAwareInstanceRegistry registry, EurekaServerContext serverContext) {
        return new EurekaServerBootstrap(this.applicationInfoManager, this.eurekaClientConfig, this.eurekaServerConfig, registry, serverContext);
    }

    @Bean
    public FilterRegistrationBean<?> jerseyFilterRegistration(ResourceConfig eurekaJerseyApp) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        ServletContainer servletContainer = new ServletContainer(eurekaJerseyApp);
        bean.setFilter((Filter)servletContainer);
        bean.setOrder(Integer.MAX_VALUE);
        bean.setUrlPatterns(Collections.singletonList("/eureka/*"));
        return bean;
    }

    @Bean
    public FilterRegistrationBean<?> eurekaVersionFilterRegistration(ServerProperties serverProperties) {
        String contextPath = serverProperties.getServlet().getContextPath();
        Object regex = "/eureka/(fonts|images|css|js)/.*";
        if (StringUtils.hasText((String)contextPath)) {
            regex = contextPath + (String)regex;
        }
        final Pattern staticPattern = Pattern.compile((String)regex);
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                Object req = request;
                String requestURI = request.getRequestURI();
                if (!requestURI.startsWith("/eureka/v2") && !staticPattern.matcher(requestURI).matches()) {
                    final String updatedPath = "/eureka/v2" + requestURI.substring("/eureka".length());
                    HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

                        public String getRequestURI() {
                            return updatedPath;
                        }

                        public String getServletPath() {
                            return updatedPath;
                        }
                    };
                    req = wrapper;
                }
                filterChain.doFilter((ServletRequest)req, (ServletResponse)response);
            }
        });
        bean.setOrder(0);
        bean.setUrlPatterns(Collections.singletonList("/eureka/*"));
        return bean;
    }

    @Bean
    public ResourceConfig jerseyApplication(Environment environment, ResourceLoader resourceLoader, final BeanFactory beanFactory) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false, environment);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Path.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Provider.class));
        HashSet<Class> classes = new HashSet<Class>();
        for (String basePackage : EUREKA_PACKAGES) {
            Set beans = provider.findCandidateComponents(basePackage);
            for (BeanDefinition bd : beans) {
                Class cls = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)resourceLoader.getClassLoader());
                classes.add(cls);
            }
        }
        ResourceConfig rc = new ResourceConfig(classes).property("jersey.config.servlet.filter.staticContentRegex", (Object)"/eureka/(fonts|images|css|js)/.*");
        rc.register((Object)new ContainerLifecycleListener(){

            public void onStartup(Container container) {
                ServiceLocator serviceLocator = (ServiceLocator)container.getApplicationHandler().getInjectionManager().getInstance(ServiceLocator.class);
                SpringBridge.getSpringBridge().initializeSpringBridge(serviceLocator);
                ((SpringIntoHK2Bridge)serviceLocator.getService(SpringIntoHK2Bridge.class, new Annotation[0])).bridgeSpringBeanFactory(beanFactory);
            }

            public void onReload(Container container) {
            }

            public void onShutdown(Container container) {
            }
        });
        return rc;
    }

    @Bean
    @ConditionalOnBean(name={"httpTraceFilter"})
    public FilterRegistrationBean<?> traceFilterRegistration(@Qualifier(value="httpTraceFilter") Filter filter) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(filter);
        bean.setOrder(0x7FFFFFF5);
        return bean;
    }

    static {
        CodecWrappers.registerWrapper((CodecWrapper)JACKSON_JSON);
        EurekaJacksonCodec.setInstance((EurekaJacksonCodec)JACKSON_JSON.getCodec());
    }

    class CloudServerCodecs
    extends DefaultServerCodecs {
        CloudServerCodecs(EurekaServerConfig serverConfig) {
            super(EurekaServerAutoConfiguration.getFullJson(serverConfig), CodecWrappers.getCodec(CodecWrappers.JacksonJsonMini.class), EurekaServerAutoConfiguration.getFullXml(serverConfig), CodecWrappers.getCodec(CodecWrappers.JacksonXmlMini.class));
        }
    }

    static class RefreshablePeerEurekaNodes
    extends PeerEurekaNodes
    implements ApplicationListener<EnvironmentChangeEvent> {
        private ReplicationClientAdditionalFilters replicationClientAdditionalFilters;

        RefreshablePeerEurekaNodes(PeerAwareInstanceRegistry registry, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, ApplicationInfoManager applicationInfoManager, ReplicationClientAdditionalFilters replicationClientAdditionalFilters) {
            super(registry, serverConfig, clientConfig, serverCodecs, applicationInfoManager);
            this.replicationClientAdditionalFilters = replicationClientAdditionalFilters;
        }

        protected PeerEurekaNode createPeerEurekaNode(String peerEurekaNodeUrl) {
            Jersey3ReplicationClient replicationClient = Jersey3ReplicationClient.createReplicationClient((EurekaServerConfig)this.serverConfig, (ServerCodecs)this.serverCodecs, (String)peerEurekaNodeUrl);
            String targetHost = RefreshablePeerEurekaNodes.hostFromUrl((String)peerEurekaNodeUrl);
            if (targetHost == null) {
                targetHost = "host";
            }
            return new PeerEurekaNode(this.registry, targetHost, peerEurekaNodeUrl, (HttpReplicationClient)replicationClient, this.serverConfig);
        }

        public void onApplicationEvent(EnvironmentChangeEvent event) {
            if (this.shouldUpdate(event.getKeys())) {
                this.updatePeerEurekaNodes(this.resolvePeerUrls());
            }
        }

        protected boolean shouldUpdate(Set<String> changedKeys) {
            assert (changedKeys != null);
            if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
                return false;
            }
            if (changedKeys.contains("eureka.client.region")) {
                return true;
            }
            for (String key : changedKeys) {
                if (!key.startsWith("eureka.client.service-url.") && !key.startsWith("eureka.client.availability-zones.")) continue;
                return true;
            }
            return false;
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class EurekaServerConfigBeanConfiguration {
        protected EurekaServerConfigBeanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EurekaServerConfig eurekaServerConfig(EurekaClientConfig clientConfig) {
            EurekaServerConfigBean server = new EurekaServerConfigBean();
            if (clientConfig.shouldRegisterWithEureka()) {
                server.setRegistrySyncRetries(5);
            }
            return server;
        }
    }
}

