/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ServerCodecs;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceCanceledEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRenewedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class InstanceRegistry
extends PeerAwareInstanceRegistryImpl
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(InstanceRegistry.class);
    private ApplicationContext ctxt;
    private int defaultOpenForTrafficCount;

    public InstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, int expectedNumberOfClientsSendingRenews, int defaultOpenForTrafficCount) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient);
        this.expectedNumberOfClientsSendingRenews = expectedNumberOfClientsSendingRenews;
        this.defaultOpenForTrafficCount = defaultOpenForTrafficCount;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.ctxt = context;
    }

    public void openForTraffic(ApplicationInfoManager applicationInfoManager, int count) {
        super.openForTraffic(applicationInfoManager, count == 0 ? this.defaultOpenForTrafficCount : count);
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        this.handleRegistration(info, leaseDuration, isReplication);
        super.register(info, leaseDuration, isReplication);
    }

    public void register(InstanceInfo info, boolean isReplication) {
        this.handleRegistration(info, this.resolveInstanceLeaseDuration(info), isReplication);
        super.register(info, isReplication);
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        this.handleCancelation(appName, serverId, isReplication);
        return super.cancel(appName, serverId, isReplication);
    }

    public boolean renew(String appName, String serverId, boolean isReplication) {
        this.log("renew " + appName + " serverId " + serverId + ", isReplication {}" + isReplication);
        List applications = this.getSortedApplications();
        for (Application input : applications) {
            if (!input.getName().equals(appName)) continue;
            InstanceInfo instance = null;
            for (InstanceInfo info : input.getInstances()) {
                if (!info.getId().equals(serverId)) continue;
                instance = info;
                break;
            }
            this.publishEvent(new EurekaInstanceRenewedEvent((Object)this, appName, serverId, instance, isReplication));
            break;
        }
        return super.renew(appName, serverId, isReplication);
    }

    protected boolean internalCancel(String appName, String id, boolean isReplication) {
        this.handleCancelation(appName, id, isReplication);
        return super.internalCancel(appName, id, isReplication);
    }

    private void handleCancelation(String appName, String id, boolean isReplication) {
        this.log("cancel " + appName + ", serverId " + id + ", isReplication " + isReplication);
        this.publishEvent(new EurekaInstanceCanceledEvent((Object)this, appName, id, isReplication));
    }

    private void handleRegistration(InstanceInfo info, int leaseDuration, boolean isReplication) {
        this.log("register " + info.getAppName() + ", vip " + info.getVIPAddress() + ", leaseDuration " + leaseDuration + ", isReplication " + isReplication);
        this.publishEvent(new EurekaInstanceRegisteredEvent((Object)this, info, leaseDuration, isReplication));
    }

    private void log(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }

    private void publishEvent(ApplicationEvent applicationEvent) {
        this.ctxt.publishEvent(applicationEvent);
    }

    private int resolveInstanceLeaseDuration(InstanceInfo info) {
        int leaseDuration = 90;
        if (info.getLeaseInfo() != null && info.getLeaseInfo().getDurationInSecs() > 0) {
            leaseDuration = info.getLeaseInfo().getDurationInSecs();
        }
        return leaseDuration;
    }
}

