/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.Objects;

public class CloudEurekaTransportConfig
implements EurekaTransportConfig {
    private int sessionedClientReconnectIntervalSeconds = 1200;
    private double retryableClientQuarantineRefreshPercentage = 0.66;
    private int bootstrapResolverRefreshIntervalSeconds = 300;
    private int applicationsResolverDataStalenessThresholdSeconds = 300;
    private int asyncResolverRefreshIntervalMs = 300000;
    private int asyncResolverWarmUpTimeoutMs = 5000;
    private int asyncExecutorThreadPoolSize = 5;
    private String readClusterVip;
    private String writeClusterVip;
    private boolean bootstrapResolverForQuery = true;
    private String bootstrapResolverStrategy;
    private boolean applicationsResolverUseIp = false;

    public boolean useBootstrapResolverForQuery() {
        return this.bootstrapResolverForQuery;
    }

    public boolean applicationsResolverUseIp() {
        return this.applicationsResolverUseIp;
    }

    public int getSessionedClientReconnectIntervalSeconds() {
        return this.sessionedClientReconnectIntervalSeconds;
    }

    public void setSessionedClientReconnectIntervalSeconds(int sessionedClientReconnectIntervalSeconds) {
        this.sessionedClientReconnectIntervalSeconds = sessionedClientReconnectIntervalSeconds;
    }

    public double getRetryableClientQuarantineRefreshPercentage() {
        return this.retryableClientQuarantineRefreshPercentage;
    }

    public void setRetryableClientQuarantineRefreshPercentage(double retryableClientQuarantineRefreshPercentage) {
        this.retryableClientQuarantineRefreshPercentage = retryableClientQuarantineRefreshPercentage;
    }

    public int getBootstrapResolverRefreshIntervalSeconds() {
        return this.bootstrapResolverRefreshIntervalSeconds;
    }

    public void setBootstrapResolverRefreshIntervalSeconds(int bootstrapResolverRefreshIntervalSeconds) {
        this.bootstrapResolverRefreshIntervalSeconds = bootstrapResolverRefreshIntervalSeconds;
    }

    public int getApplicationsResolverDataStalenessThresholdSeconds() {
        return this.applicationsResolverDataStalenessThresholdSeconds;
    }

    public void setApplicationsResolverDataStalenessThresholdSeconds(int applicationsResolverDataStalenessThresholdSeconds) {
        this.applicationsResolverDataStalenessThresholdSeconds = applicationsResolverDataStalenessThresholdSeconds;
    }

    public int getAsyncResolverRefreshIntervalMs() {
        return this.asyncResolverRefreshIntervalMs;
    }

    public void setAsyncResolverRefreshIntervalMs(int asyncResolverRefreshIntervalMs) {
        this.asyncResolverRefreshIntervalMs = asyncResolverRefreshIntervalMs;
    }

    public int getAsyncResolverWarmUpTimeoutMs() {
        return this.asyncResolverWarmUpTimeoutMs;
    }

    public void setAsyncResolverWarmUpTimeoutMs(int asyncResolverWarmUpTimeoutMs) {
        this.asyncResolverWarmUpTimeoutMs = asyncResolverWarmUpTimeoutMs;
    }

    public int getAsyncExecutorThreadPoolSize() {
        return this.asyncExecutorThreadPoolSize;
    }

    public void setAsyncExecutorThreadPoolSize(int asyncExecutorThreadPoolSize) {
        this.asyncExecutorThreadPoolSize = asyncExecutorThreadPoolSize;
    }

    public String getReadClusterVip() {
        return this.readClusterVip;
    }

    public void setReadClusterVip(String readClusterVip) {
        this.readClusterVip = readClusterVip;
    }

    public String getWriteClusterVip() {
        return this.writeClusterVip;
    }

    public void setWriteClusterVip(String writeClusterVip) {
        this.writeClusterVip = writeClusterVip;
    }

    public boolean isBootstrapResolverForQuery() {
        return this.bootstrapResolverForQuery;
    }

    public void setBootstrapResolverForQuery(boolean bootstrapResolverForQuery) {
        this.bootstrapResolverForQuery = bootstrapResolverForQuery;
    }

    public String getBootstrapResolverStrategy() {
        return this.bootstrapResolverStrategy;
    }

    public void setBootstrapResolverStrategy(String bootstrapResolverStrategy) {
        this.bootstrapResolverStrategy = bootstrapResolverStrategy;
    }

    public boolean isApplicationsResolverUseIp() {
        return this.applicationsResolverUseIp;
    }

    public void setApplicationsResolverUseIp(boolean applicationsResolverUseIp) {
        this.applicationsResolverUseIp = applicationsResolverUseIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEurekaTransportConfig that = (CloudEurekaTransportConfig)o;
        return this.sessionedClientReconnectIntervalSeconds == that.sessionedClientReconnectIntervalSeconds && Double.compare(this.retryableClientQuarantineRefreshPercentage, that.retryableClientQuarantineRefreshPercentage) == 0 && this.bootstrapResolverRefreshIntervalSeconds == that.bootstrapResolverRefreshIntervalSeconds && this.applicationsResolverDataStalenessThresholdSeconds == that.applicationsResolverDataStalenessThresholdSeconds && this.asyncResolverRefreshIntervalMs == that.asyncResolverRefreshIntervalMs && this.asyncResolverWarmUpTimeoutMs == that.asyncResolverWarmUpTimeoutMs && this.asyncExecutorThreadPoolSize == that.asyncExecutorThreadPoolSize && Objects.equals(this.readClusterVip, that.readClusterVip) && Objects.equals(this.writeClusterVip, that.writeClusterVip) && this.bootstrapResolverForQuery == that.bootstrapResolverForQuery && Objects.equals(this.bootstrapResolverStrategy, that.bootstrapResolverStrategy) && this.applicationsResolverUseIp == that.applicationsResolverUseIp;
    }

    public int hashCode() {
        return Objects.hash(this.sessionedClientReconnectIntervalSeconds, this.retryableClientQuarantineRefreshPercentage, this.bootstrapResolverRefreshIntervalSeconds, this.applicationsResolverDataStalenessThresholdSeconds, this.asyncResolverRefreshIntervalMs, this.asyncResolverWarmUpTimeoutMs, this.asyncExecutorThreadPoolSize, this.readClusterVip, this.writeClusterVip, this.bootstrapResolverForQuery, this.bootstrapResolverStrategy, this.applicationsResolverUseIp);
    }

    public String toString() {
        return "CloudEurekaTransportConfig{" + "sessionedClientReconnectIntervalSeconds=" + this.sessionedClientReconnectIntervalSeconds + ", " + "retryableClientQuarantineRefreshPercentage=" + this.retryableClientQuarantineRefreshPercentage + ", " + "bootstrapResolverRefreshIntervalSeconds=" + this.bootstrapResolverRefreshIntervalSeconds + ", " + "applicationsResolverDataStalenessThresholdSeconds=" + this.applicationsResolverDataStalenessThresholdSeconds + ", " + "asyncResolverRefreshIntervalMs=" + this.asyncResolverRefreshIntervalMs + ", " + "asyncResolverWarmUpTimeoutMs=" + this.asyncResolverWarmUpTimeoutMs + ", " + "asyncExecutorThreadPoolSize=" + this.asyncExecutorThreadPoolSize + ", " + "readClusterVip='" + this.readClusterVip + "', " + "writeClusterVip='" + this.writeClusterVip + "', " + "bootstrapResolverForQuery=" + this.bootstrapResolverForQuery + ", " + "bootstrapResolverStrategy='" + this.bootstrapResolverStrategy + "', " + "applicationsResolverUseIp=" + this.applicationsResolverUseIp + ", " + "}";
    }
}

