/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.http.codec.CodecsAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.cloud.netflix.eureka.http.RestTemplateEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactory;
import org.springframework.cloud.netflix.eureka.http.WebClientEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.WebClientTransportClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;

@ConditionalOnClass(value={ConfigServicePropertySourceLocator.class})
@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
public class EurekaConfigServerBootstrapConfiguration {
    private static final Log log = LogFactory.getLog(EurekaConfigServerBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={EurekaClientConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaClientConfigBean eurekaClientConfigBean() {
        return new EurekaClientConfigBean();
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaHttpClient.class})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, matchIfMissing=true, havingValue="false")
    public RestTemplateEurekaHttpClient configDiscoveryRestTemplateEurekaHttpClient(EurekaClientConfigBean config, Environment env) {
        return (RestTemplateEurekaHttpClient)new RestTemplateTransportClientFactory().newClient((EurekaEndpoint)new DefaultEndpoint(EurekaConfigServerBootstrapConfiguration.getEurekaUrl(config, env)));
    }

    private static String getEurekaUrl(EurekaClientConfigBean config, Environment env) {
        List urls = EndpointUtils.getDiscoveryServiceUrls((EurekaClientConfig)config, (String)"defaultZone", (EndpointUtils.ServiceUrlRandomizer)new HostnameBasedUrlRandomizer(env.getProperty("eureka.instance.hostname")));
        return (String)urls.get(0);
    }

    private boolean isSuccessful(EurekaHttpResponse<Applications> response) {
        HttpStatus httpStatus = HttpStatus.resolve((int)response.getStatusCode());
        return httpStatus != null && httpStatus.is2xxSuccessful();
    }

    @Bean
    public ConfigServerInstanceProvider.Function eurekaConfigServerInstanceProvider(EurekaHttpClient client, EurekaClientConfig config) {
        return serviceId -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("eurekaConfigServerInstanceProvider finding instances for " + serviceId));
            }
            EurekaHttpResponse response = client.getApplications(new String[]{config.getRegion()});
            ArrayList<EurekaServiceInstance> instances = new ArrayList<EurekaServiceInstance>();
            if (!this.isSuccessful((EurekaHttpResponse<Applications>)response) || response.getEntity() == null) {
                return instances;
            }
            Applications applications = (Applications)response.getEntity();
            applications.shuffleInstances(config.shouldFilterOnlyUpInstances());
            List infos = applications.getInstancesByVirtualHostName(serviceId);
            for (InstanceInfo info : infos) {
                instances.add(new EurekaServiceInstance(info));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("eurekaConfigServerInstanceProvider found " + infos.size() + " instance(s) for " + serviceId + ", " + instances));
            }
            return instances;
        };
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    @ImportAutoConfiguration(value={CodecsAutoConfiguration.class, WebClientAutoConfiguration.class})
    protected static class WebClientConfiguration {
        protected WebClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={EurekaHttpClient.class})
        public WebClientEurekaHttpClient configDiscoveryWebClientEurekaHttpClient(EurekaClientConfigBean config, ObjectProvider<WebClient.Builder> builder, Environment env) {
            return (WebClientEurekaHttpClient)new WebClientTransportClientFactory(() -> builder.getIfAvailable()).newClient((EurekaEndpoint)new DefaultEndpoint(EurekaConfigServerBootstrapConfiguration.getEurekaUrl(config, env)));
        }
    }

    private static final class HostnameBasedUrlRandomizer
    implements EndpointUtils.ServiceUrlRandomizer {
        private final String hostname;

        private HostnameBasedUrlRandomizer(String hostname) {
            this.hostname = hostname;
        }

        public void randomize(List<String> urlList) {
            int listSize = 0;
            if (urlList != null) {
                listSize = urlList.size();
            }
            if (!StringUtils.hasText((String)this.hostname) || listSize == 0) {
                return;
            }
            int instanceHashcode = this.hostname.hashCode();
            if (instanceHashcode < 0) {
                instanceHashcode *= -1;
            }
            int backupInstance = instanceHashcode % listSize;
            for (int i = 0; i < backupInstance; ++i) {
                String zone = urlList.remove(0);
                urlList.add(zone);
            }
        }
    }
}

