/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.loadbalancer;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.EurekaClientConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.netflix.eureka.loadbalancer.EurekaLoadBalancerProperties;
import org.springframework.cloud.netflix.ribbon.eureka.ZoneUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(value={LoadBalancerProperties.class, EurekaLoadBalancerProperties.class})
public class EurekaLoadBalancerClientConfiguration {
    private static final String LOADBALANCER_ZONE = "spring.cloud.loadbalancer.zone";
    private static final Log LOG = LogFactory.getLog(EurekaLoadBalancerClientConfiguration.class);
    private final EurekaClientConfig clientConfig;
    private final EurekaInstanceConfig eurekaConfig;
    private final LoadBalancerProperties loadBalancerProperties;
    private final EurekaLoadBalancerProperties eurekaLoadBalancerProperties;

    public EurekaLoadBalancerClientConfiguration(@Autowired(required=false) EurekaClientConfig clientConfig, @Autowired(required=false) EurekaInstanceConfig eurekaInstanceConfig, LoadBalancerProperties loadBalancerProperties, EurekaLoadBalancerProperties eurekaLoadBalancerProperties) {
        this.clientConfig = clientConfig;
        this.eurekaConfig = eurekaInstanceConfig;
        this.loadBalancerProperties = loadBalancerProperties;
        this.eurekaLoadBalancerProperties = eurekaLoadBalancerProperties;
    }

    @PostConstruct
    public void postprocess() {
        if (!StringUtils.isEmpty((Object)this.loadBalancerProperties.getZone())) {
            return;
        }
        String zone = this.getZoneFromEureka();
        if (!StringUtils.isEmpty((Object)zone)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting the value of 'spring.cloud.loadbalancer.zone' to " + zone));
            }
            this.loadBalancerProperties.setZone(zone);
        }
    }

    private String getZoneFromEureka() {
        String zone;
        boolean approximateZoneFromHostname = this.eurekaLoadBalancerProperties.isApproximateZoneFromHostname();
        if (approximateZoneFromHostname && this.eurekaConfig != null) {
            return ZoneUtils.extractApproximateZone(this.eurekaConfig.getHostName(false));
        }
        String string = zone = this.eurekaConfig == null ? null : (String)this.eurekaConfig.getMetadataMap().get("zone");
        if (StringUtils.isEmpty(zone)) {
            String[] zones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
            zone = zones != null && zones.length > 0 ? zones[0] : null;
        }
        return zone;
    }
}

