/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.DefaultHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.HealthIndicatorRegistryFactory;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthIndicator;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class EurekaHealthCheckHandler
implements HealthCheckHandler,
ApplicationContextAware,
InitializingBean {
    private static final Map<Status, InstanceInfo.InstanceStatus> STATUS_MAPPING = new HashMap<Status, InstanceInfo.InstanceStatus>(){
        {
            this.put(Status.UNKNOWN, InstanceInfo.InstanceStatus.UNKNOWN);
            this.put(Status.OUT_OF_SERVICE, InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
            this.put(Status.DOWN, InstanceInfo.InstanceStatus.DOWN);
            this.put(Status.UP, InstanceInfo.InstanceStatus.UP);
        }
    };
    private CompositeHealthIndicator healthIndicator;
    private ApplicationContext applicationContext;
    private HealthIndicatorRegistryFactory healthIndicatorRegistryFactory;
    private HealthAggregator healthAggregator;

    public EurekaHealthCheckHandler(HealthAggregator healthAggregator) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        this.healthAggregator = healthAggregator;
        this.healthIndicatorRegistryFactory = new HealthIndicatorRegistryFactory();
        this.healthIndicator = new CompositeHealthIndicator(this.healthAggregator, (HealthIndicatorRegistry)new DefaultHealthIndicatorRegistry());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map healthIndicators = this.applicationContext.getBeansOfType(HealthIndicator.class);
        HashMap<String, Object> finalHealthIndicators = new HashMap<String, Object>();
        for (Map.Entry entry : healthIndicators.entrySet()) {
            if (entry.getValue() instanceof DiscoveryCompositeHealthIndicator) {
                DiscoveryCompositeHealthIndicator indicator = (DiscoveryCompositeHealthIndicator)entry.getValue();
                for (DiscoveryCompositeHealthIndicator.Holder holder : indicator.getHealthIndicators()) {
                    if (holder.getDelegate() instanceof EurekaHealthIndicator) continue;
                    finalHealthIndicators.put(holder.getDelegate().getName(), holder);
                }
                continue;
            }
            finalHealthIndicators.put((String)entry.getKey(), entry.getValue());
        }
        this.healthIndicator = new CompositeHealthIndicator(this.healthAggregator, this.healthIndicatorRegistryFactory.createHealthIndicatorRegistry(finalHealthIndicators));
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus instanceStatus) {
        return this.getHealthStatus();
    }

    protected InstanceInfo.InstanceStatus getHealthStatus() {
        Status status = this.getHealthIndicator().health().getStatus();
        return this.mapToInstanceStatus(status);
    }

    protected InstanceInfo.InstanceStatus mapToInstanceStatus(Status status) {
        if (!STATUS_MAPPING.containsKey(status)) {
            return InstanceInfo.InstanceStatus.UNKNOWN;
        }
        return STATUS_MAPPING.get(status);
    }

    protected CompositeHealthIndicator getHealthIndicator() {
        return this.healthIndicator;
    }
}

