/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.eureka;

import com.netflix.discovery.EurekaClient;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnRibbonAndEurekaEnabledCondition.class})
public @interface ConditionalOnRibbonAndEurekaEnabled {

    public static class OnRibbonAndEurekaEnabledCondition
    extends AllNestedConditions {
        public OnRibbonAndEurekaEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
        static class OnEurekaClientEnabled {
            OnEurekaClientEnabled() {
            }
        }

        @ConditionalOnBean(value={EurekaClient.class})
        static class EurekaBeans {
            EurekaBeans() {
            }
        }

        @ConditionalOnClass(value={DiscoveryEnabledNIWSServerList.class})
        @ConditionalOnBean(value={SpringClientFactory.class})
        @ConditionalOnProperty(value={"ribbon.eureka.enabled"}, matchIfMissing=true)
        static class Defaults {
            Defaults() {
            }
        }
    }
}

