/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.localconfig;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.springframework.cloud.util.EnvironmentAccessor;

class PropertiesFileResolver {
    public static final String BOOTSTRAP_PROPERTIES_FILENAME = "spring-cloud-bootstrap.properties";
    private static final Logger logger = Logger.getLogger(PropertiesFileResolver.class.getName());
    private final EnvironmentAccessor env;
    private final String classpathPropertiesFilename;

    PropertiesFileResolver(EnvironmentAccessor env, String classpathPropertiesFilename) {
        this.env = env;
        this.classpathPropertiesFilename = classpathPropertiesFilename;
    }

    PropertiesFileResolver(EnvironmentAccessor env) {
        this(env, BOOTSTRAP_PROPERTIES_FILENAME);
    }

    PropertiesFileResolver() {
        this(new EnvironmentAccessor());
    }

    File findCloudPropertiesFileFromSystem() {
        String filename = null;
        try {
            filename = this.env.getSystemProperty("spring.cloud.propertiesFile");
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "SecurityManager prevented reading system property spring.cloud.propertiesFile", e);
            return null;
        }
        if (filename == null) {
            logger.fine("didn't find system property for a configuration file");
            return null;
        }
        File file = new File(filename);
        logger.info("found system property for a configuration file: " + file);
        return file;
    }

    File findCloudPropertiesFileFromClasspath() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.classpathPropertiesFilename);
        if (in == null) {
            logger.info("no " + this.classpathPropertiesFilename + " found on the classpath to direct us to an external properties file");
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "found " + this.classpathPropertiesFilename + " on the classpath but couldn't load it as a properties file", e);
            return null;
        }
        String template = properties.getProperty("spring.cloud.propertiesFile");
        if (template == null) {
            logger.log(Level.SEVERE, "found properties file " + this.classpathPropertiesFilename + " on the classpath, but it didn't contain a property named " + "spring.cloud.propertiesFile");
            return null;
        }
        if (properties.entrySet().size() > 1) {
            logger.warning("the properties file " + this.classpathPropertiesFilename + " contained properties besides " + "spring.cloud.propertiesFile" + "; ignoring");
        }
        logger.fine("substituting system properties into '" + template + "'");
        File configFile = new File(new StrSubstitutor(this.systemPropertiesLookup(this.env)).replace(template));
        logger.info("derived configuration file name: " + configFile);
        return configFile;
    }

    File findCloudPropertiesFile() {
        File file = this.findCloudPropertiesFileFromSystem();
        if (file != null) {
            logger.info("using configuration file from system properties");
            return file;
        }
        file = this.findCloudPropertiesFileFromClasspath();
        if (file != null) {
            logger.info("using configuration file derived from " + this.classpathPropertiesFilename);
        } else {
            logger.info("did not find any Spring Cloud configuration file");
        }
        return file;
    }

    private StrLookup<String> systemPropertiesLookup(final EnvironmentAccessor env) {
        return new StrLookup<String>(){

            public String lookup(String key) {
                return env.getSystemProperty(key);
            }
        };
    }
}

